#!/bin/bash
# S. Salewski, 26-MAY-2014
# generate GTK3 bindings for Nimrod -- this is for GTK headers 3.12.1
#
gtk3_dir="/home/stefan/Downloads/gtk+-3.12.1" # have currently only 3.10.8 lib installed!
final="final.h" # the input file for c2nim
list="list.txt"
wdir="tmp_gtk"

targets='a11y deprecated'
all_t=". ${targets}"

rm -rf $wdir # start from scratch
mkdir $wdir
cd $wdir
cp -r $gtk3_dir/gtk .
cd gtk

# check already done for 3.12...
#echo 'we may miss these headers -- please check:'
#for i in $all_t ; do
#  grep -c DECL ${i}/*.h | grep h:0
#done

# we insert in each header a marker with the filename
# may fail if G_BEGIN_DECLS macro is missing in a header
for j in $all_t ; do
  for i in ${j}/*.h; do
    sed -i "/^G_BEGIN_DECLS/a${i}_ssalewski;" $i
  done
done

cat gtk.h gtk-a11y.h > all.h

cd ..

# cpp run with all headers to determine order
echo "cat \\" > $list

cpp -I. `pkg-config --cflags gtk+-3.0` gtk/all.h $final

# extract file names and push names to list
grep ssalewski $final | sed 's/_ssalewski;/ \\/' >> $list

# maybe add remaining missing headers
# for now we put all at the bottom and do manually insertion if we need these at all
# echo 'gtkactionhelper.h \' >> $list  # do not add, it uses G_GNUC_INTERNAL macro, so it really only for internal use
echo 'gtkintl.h \' >> $list
echo 'gtkmenutracker.h \' >> $list # do we need this?
echo 'gtkmenutrackeritem.h \' >> $list

i=`uniq -d $list | wc -l`
if [ $i != 0 ]; then echo 'list contains duplicates!'; exit; fi;

# now we work again with original headers
rm -rf gtk
cp -r $gtk3_dir/gtk . 

# insert for each header file its name as first line
for j in $all_t ; do
  for i in gtk/${j}/*.h; do
    sed -i "1i/* file: $i */" $i
  done
done
cd gtk
  bash ../$list > ../$final
cd ..
#rm $list

# delete strange macros
# we restrict use of wildcards to limit risc of damage something!
for i in 2 4 6 8 10 12 ; do
  sed -i "1i#def GDK_AVAILABLE_IN_3_$i\n#def GDK_DEPRECATED_IN_3_$i\n#def GDK_DEPRECATED_IN_3_${i}_FOR(x)" $final
done

sed -i "1i#def G_BEGIN_DECLS" $final
sed -i "1i#def G_END_DECLS" $final

sed -i 's/^G_BEGIN_DECLS//' $final
sed -i 's/^G_GNUC_WARN_UNUSED_RESULT //' $final
sed -i "1i#def GDK_AVAILABLE_IN_ALL" $final
sed -i "1i#def GDK_DEPRECATED" $final
sed -i "1i#def G_DEPRECATED" $final
sed -i "1i#def GDK_DEPRECATED_IN_3_0" $final
sed -i "1i#def GDK_DEPRECATED_IN_3_0_FOR(x)" $final

sed -i "1i#def G_GNUC_MALLOC" $final
sed -i "1i#def G_GNUC_CONST" $final
sed -i "1i#def GDK_THREADS_DEPRECATED" $final
sed -i "1i#def G_GNUC_WARN_UNUSED_RESULT" $final

sed -i "1i#def G_GNUC_NULL_TERMINATED" $final
sed -i "1i#def G_GNUC_PRINTF(i,j)" $final

# add missing () for macro names
sed -i 's/#define \(\w\w*\)\(\s\{1,\}(\w\w* \{1,\}())$\)/#define \1() \2/g' $final
sed -i 's/#define GTK_ICON_THEME_ERROR gtk_icon_theme_error_quark ()/#define GTK_ICON_THEME_ERROR() gtk_icon_theme_error_quark ()/g' $final
sed -i 's/#define GTK_TYPE_INFO_BAR              (gtk_info_bar_get_type())/#define GTK_TYPE_INFO_BAR()              (gtk_info_bar_get_type())/g' $final
sed -i 's/#define	GTK_TYPE_MENU_BAR               (gtk_menu_bar_get_type ())/#define	GTK_TYPE_MENU_BAR()               (gtk_menu_bar_get_type ())/g' $final
sed -i 's/#define GTK_PRINT_ERROR gtk_print_error_quark ()/#define GTK_PRINT_ERROR() gtk_print_error_quark ()/g' $final

# sorry, not possible. will conflict with other patches we already did. have to do this manually as a final step.
#sed -i "/file: gtk\/deprecated\/gtkaction.h/a#ifdef deprecated" $final
#sed -i "/file: gtk\/a11y/a#endif\n#ifdef a11y" $final

perl -0777 -p -i -e 's/#if !?defined.*?error.*?#endif//sg' $final

# add missing private/opaque data types
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkAccelGroupPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkBuilderPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkWidgetPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkSelectionData {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkTooltip {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkClipboard {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkWidgetPath {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkAppChooserWidgetPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkColorChooserWidgetPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkFontChooser {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkFontChooserWidgetPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkWidgetClassPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkSettingsPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkApplicationPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkContainerPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkAdjustmentPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkBinPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkWindowPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkWindowGroupPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkDialogPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkAboutDialogPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkMiscPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkMenuPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkMenuShellPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkLabelPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkAccessiblePrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkAccelLabelPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkAlignmentPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkBoxPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkAccelMap {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkAppChooser {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkAppChooserDialogPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkActionable {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkTreeModel {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkTreePath {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkTreeRowReference {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkCellEditable {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkCellRendererPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkCellRendererClassPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkCellAreaPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkCellAreaContextPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkTreeSortable {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkTreeViewColumnPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkTextTagPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkTextBufferPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkListStorePrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkEntryBufferPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkTreeModelFilterPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkTargetList {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkEditable {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkEntryCompletionPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkImagePrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkEntryPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkTreeViewPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkComboBoxPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkAppChooserButtonPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkArrowPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkApplicationWindowPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkTreeSelectionPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkFramePrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkCalendarPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkAspectFramePrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkButtonBoxPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkAssistantPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkCellAreaBoxPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkIconSet {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkBuildable {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkButtonPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkCellRendererTextPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkCellRendererAccelPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkCellRendererComboPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkCellRendererPixbufPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkCellRendererProgressPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkCellRendererSpinPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkCellRendererSpinnerPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkToggleButtonPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkColorChooserDialogPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkColorButtonPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkCellViewPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkExpanderPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkFixedPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkMenuItemPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkCheckMenuItemPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkCellRendererTogglePrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkComboBoxTextPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkEventBoxPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkCssProviderPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkCellLayout {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkColorChooser {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkCssSection {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkFileFilter {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkFileChooser {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkFileChooserButtonPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkFileChooserDialogPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkIconSource {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkIconInfo {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkFontButtonPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkFontChooserDialogPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkSymbolicColor {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkFileChooserWidgetPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkGridPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkIconFactoryPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkStylePropertiesPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkStyleContextPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkIconThemePrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkIconViewPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkIMContextSimplePrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkIMMulticontextPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkInfoBarPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkInvisiblePrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkLayoutPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkLevelBarPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkLinkButtonPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkLockButtonPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkMenuBarPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkPopoverPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkMenuButtonPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkToolItemPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkToolButtonPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkMenuToolButtonPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkMessageDialogPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkMountOperationPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkNotebookPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkNumerableIconPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkOverlayPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkPanedPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkPrintOperationPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkProgressBarPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkRadioButtonPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkRadioMenuItemPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkToggleToolButtonPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkRangePrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkRecentChooserWidgetPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkRecentChooserDialogPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkRecentChooserMenuPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkRecentChooser {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkScalePrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkScaleButtonPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkScrolledWindowPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkSeparatorPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkSeparatorToolItemPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkSpinButtonPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkSpinnerPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkStatusbarPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkStatusIconPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkSwitchPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkTextTagTablePrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkTextViewPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkThemingEnginePrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkToolbarPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkToolItemGroupPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkToolPalettePrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkTreeModelSortPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkTreeStorePrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkViewportPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkActionPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkActionGroupPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkColorSelectionPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkColorSelectionDialogPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkFontSelectionDialogPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkFontSelectionPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkHandleBoxPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkHSVPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkImageMenuItemPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkToggleActionPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkRadioActionPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkRecentActionPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkTablePrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkTearoffMenuItemPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkUIManagerPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkRecentManagerPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkSizeGroupPrivate {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkStyleProvider {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkOrientable {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkPaperSize {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkPageSetup {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkPrintContext {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkPlacesSidebar {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkPrintSettings {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkPrintOperationPreview {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkRecentInfo {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkRecentFilter {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkScrollable {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkTextBTree {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkToolShell {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkTreeDragSource {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkTreeDragDest {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkActivatable {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkGradient {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkMenuTrackerItem {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkActionObservable {};" $final
sed -i "/#define __GTK_ACCEL_GROUP_H__/astruct _GtkMenuTracker {};" $final

perl -0777 -p -i -e "s%/\* (file: gtk/a11y/.* \*/\n)%/\* start of a11y section \1%" final.h

#put the a11y private types at the start of that section
sed -i "/#define __GTK_WIDGET_ACCESSIBLE_H__/astruct _WidgetAccessiblePrivate {};" $final
sed -i "/#define __GTK_WIDGET_ACCESSIBLE_H__/astruct _ArrowAccessiblePrivate {};" $final
sed -i "/#define __GTK_WIDGET_ACCESSIBLE_H__/astruct _CellAccessiblePrivate {};" $final
sed -i "/#define __GTK_WIDGET_ACCESSIBLE_H__/astruct _RendererCellAccessiblePrivate {};" $final
sed -i "/#define __GTK_WIDGET_ACCESSIBLE_H__/astruct _BooleanCellAccessiblePrivate {};" $final
sed -i "/#define __GTK_WIDGET_ACCESSIBLE_H__/astruct _ContainerAccessiblePrivate {};" $final
sed -i "/#define __GTK_WIDGET_ACCESSIBLE_H__/astruct _ButtonAccessiblePrivate {};" $final
sed -i "/#define __GTK_WIDGET_ACCESSIBLE_H__/astruct _MenuItemAccessiblePrivate {};" $final
sed -i "/#define __GTK_WIDGET_ACCESSIBLE_H__/astruct _CheckMenuItemAccessiblePrivate {};" $final
sed -i "/#define __GTK_WIDGET_ACCESSIBLE_H__/astruct _ComboBoxAccessiblePrivate {};" $final
sed -i "/#define __GTK_WIDGET_ACCESSIBLE_H__/astruct _ContainerCellAccessiblePrivate {};" $final
sed -i "/#define __GTK_WIDGET_ACCESSIBLE_H__/astruct _EntryAccessiblePrivate {};" $final
sed -i "/#define __GTK_WIDGET_ACCESSIBLE_H__/astruct _ExpanderAccessiblePrivate {};" $final
sed -i "/#define __GTK_WIDGET_ACCESSIBLE_H__/astruct _FlowBoxAccessiblePrivate {};" $final
sed -i "/#define __GTK_WIDGET_ACCESSIBLE_H__/astruct _FrameAccessiblePrivate {};" $final
sed -i "/#define __GTK_WIDGET_ACCESSIBLE_H__/astruct _IconViewAccessiblePrivate {};" $final
sed -i "/#define __GTK_WIDGET_ACCESSIBLE_H__/astruct _ImageAccessiblePrivate {};" $final
sed -i "/#define __GTK_WIDGET_ACCESSIBLE_H__/astruct _ImageCellAccessiblePrivate {};" $final
sed -i "/#define __GTK_WIDGET_ACCESSIBLE_H__/astruct _LevelBarAccessiblePrivate {};" $final
sed -i "/#define __GTK_WIDGET_ACCESSIBLE_H__/astruct _LabelAccessiblePrivate {};" $final
sed -i "/#define __GTK_WIDGET_ACCESSIBLE_H__/astruct _LinkButtonAccessiblePrivate {};" $final
sed -i "/#define __GTK_WIDGET_ACCESSIBLE_H__/astruct _ListBoxAccessiblePrivate {};" $final
sed -i "/#define __GTK_WIDGET_ACCESSIBLE_H__/astruct _LockButtonAccessiblePrivate {};" $final
sed -i "/#define __GTK_WIDGET_ACCESSIBLE_H__/astruct _MenuShellAccessiblePrivate {};" $final
sed -i "/#define __GTK_WIDGET_ACCESSIBLE_H__/astruct _MenuAccessiblePrivate {};" $final
sed -i "/#define __GTK_WIDGET_ACCESSIBLE_H__/astruct _ToggleButtonAccessiblePrivate {};" $final
sed -i "/#define __GTK_WIDGET_ACCESSIBLE_H__/astruct _MenuButtonAccessiblePrivate {};" $final
sed -i "/#define __GTK_WIDGET_ACCESSIBLE_H__/astruct _NotebookAccessiblePrivate {};" $final
sed -i "/#define __GTK_WIDGET_ACCESSIBLE_H__/astruct _NotebookPageAccessiblePrivate {};" $final
sed -i "/#define __GTK_WIDGET_ACCESSIBLE_H__/astruct _PanedAccessiblePrivate{};" $final
sed -i "/#define __GTK_WIDGET_ACCESSIBLE_H__/astruct _ProgressBarAccessiblePrivate {};" $final
sed -i "/#define __GTK_WIDGET_ACCESSIBLE_H__/astruct _RadioButtonAccessiblePrivate {};" $final
sed -i "/#define __GTK_WIDGET_ACCESSIBLE_H__/astruct _RadioMenuItemAccessiblePrivate {};" $final
sed -i "/#define __GTK_WIDGET_ACCESSIBLE_H__/astruct _RangeAccessiblePrivate {};" $final
sed -i "/#define __GTK_WIDGET_ACCESSIBLE_H__/astruct _ScaleAccessiblePrivate {};" $final
sed -i "/#define __GTK_WIDGET_ACCESSIBLE_H__/astruct _ScaleButtonAccessiblePrivate {};" $final
sed -i "/#define __GTK_WIDGET_ACCESSIBLE_H__/astruct _ScrolledWindowAccessiblePrivate {};" $final
sed -i "/#define __GTK_WIDGET_ACCESSIBLE_H__/astruct _SpinButtonAccessiblePrivate {};" $final
sed -i "/#define __GTK_WIDGET_ACCESSIBLE_H__/astruct _SpinnerAccessiblePrivate {};" $final
sed -i "/#define __GTK_WIDGET_ACCESSIBLE_H__/astruct _StatusbarAccessiblePrivate {};" $final
sed -i "/#define __GTK_WIDGET_ACCESSIBLE_H__/astruct _SwitchAccessiblePrivate {};" $final
sed -i "/#define __GTK_WIDGET_ACCESSIBLE_H__/astruct _TextCellAccessiblePrivate {};" $final
sed -i "/#define __GTK_WIDGET_ACCESSIBLE_H__/astruct _TextViewAccessiblePrivate {};" $final
sed -i "/#define __GTK_WIDGET_ACCESSIBLE_H__/astruct _ToplevelAccessiblePrivate {};" $final
sed -i "/#define __GTK_WIDGET_ACCESSIBLE_H__/astruct _TreeViewAccessiblePrivate {};" $final
sed -i "/#define __GTK_WIDGET_ACCESSIBLE_H__/astruct _WindowAccessiblePrivate {};" $final
sed -i "/#define __GTK_WIDGET_ACCESSIBLE_H__/astruct _CellAccessibleParent {};" $final

ruby ../fix_.rb $final

# the header -- entries for win32 and macosx is a guess. Please fix if you know lib names.
i='
#ifdef __INCREASE_TMP_INDENT__
#ifdef C2NIM
#  dynlib lib
#  cdecl
#  if defined(win32)
#    define lib "libgdk-win32-3.0-0.dll"
#  elif defined(macosx)
#    define lib "libgdk-quartz-3.0.dylib"
#  else
#    define lib "libgtk-3.so(|.0)"
#  endif
#endif
'
echo "$i" > tmp1.txt

# this is missing from current cairo
# struct cairo_region_t {};
i='
struct region {};
'
echo "$i" >> tmp1.txt

# some data types currently missing in nimrods glib2
# GFile, GMenuModel, GActionGroup, GAppInfo, GApplication, GMountOperation, GEmblemedIcon, GIcon,
# GPermission, GAsyncResult from gio.h
# GMountOperationClass is from gtk3-Filesystem-utilities
# va_list data type is wrong, only defined to make it compile!
# time_t may be problematic, because OS dependent!
i='
typedef TGObject TGInitiallyUnowned;
typedef TGObjectClass TGInitiallyUnownedClass;
typedef PGObject PGFile;
typedef PGObject PGIcon;
typedef PGObject PGMenuModel;
typedef PGObject PGVariant;
typedef PGObject PGActionGroup;
typedef PGObject va_list;
typedef PGObject PGBytes;
typedef PGObject PGAppInfo;
typedef GObject TGApplication;
typedef GObjectClass TGApplicationClass;
typedef PGObject PGCancellable;
typedef GObject GMountOperation;
typedef PGObject PGMountOperation;
typedef GObjectClass GMountOperationClass;
typedef GObjectClass GEmblemedIconClass;
typedef GObject GEmblemedIcon;
typedef PGObject PGAsyncResult;
typedef PGObject PGPermission;
typedef PGObject PGOptionGroup;
typedef PGObject PGKeyFile;
typedef unsigned long int  time_t;
typedef unsigned long int *Ptime_t;
'
echo "$i" >> tmp1.txt

#data types currently missing in nimrods pango
i='
typedef enum {
  PANGO_ELLIPSIZE_NONE,
  PANGO_ELLIPSIZE_START,
  PANGO_ELLIPSIZE_MIDDLE,
  PANGO_ELLIPSIZE_END
} EllipsizeMode;
'
echo "$i" >> tmp1.txt

#data types from missing gio.h
i='
typedef enum
{
  G_APPLICATION_FLAGS_NONE,
  G_APPLICATION_IS_SERVICE  =          (1 << 0),
  G_APPLICATION_IS_LAUNCHER =          (1 << 1),
  G_APPLICATION_HANDLES_OPEN =         (1 << 2),
  G_APPLICATION_HANDLES_COMMAND_LINE = (1 << 3),
  G_APPLICATION_SEND_ENVIRONMENT    =  (1 << 4),
  G_APPLICATION_NON_UNIQUE =           (1 << 5)
} GApplicationFlags;
'
echo "$i" >> tmp1.txt

# from gio.h
i='
typedef void (*GAsyncReadyCallback) (GObject *source_object,
                                     GAsyncResult *res,
                                     gpointer user_data);
'
echo "$i" >> tmp1.txt

# from glib/goption.h, GArray from glib
i='
typedef enum
{
  G_OPTION_ARG_NONE,
  G_OPTION_ARG_STRING,
  G_OPTION_ARG_INT,
  G_OPTION_ARG_CALLBACK,
  G_OPTION_ARG_FILENAME,
  G_OPTION_ARG_STRING_ARRAY,
  G_OPTION_ARG_FILENAME_ARRAY,
  G_OPTION_ARG_DOUBLE,
  G_OPTION_ARG_INT64
} GOptionArg;

struct GOptionEntry
{
  const gchar *long_name;
  gchar        short_name;
  gint         flags;

  GOptionArg   arg;
  gpointer     arg_data;
  
  const gchar *description;
  const gchar *arg_description;
};

struct GArray
{
  gchar *data;
  guint len;
};
'
echo "$i" >> tmp1.txt

echo "#endif\n" >> tmp1.txt #ifdef __INCREASE_TMP_INDENT__

cat tmp1.txt $final > tmp2.txt
mv tmp2.txt $final
rm tmp1.txt

i="\
#ifdef G_PLATFORM_WIN32
#include <gtk/gtkbox.h>
#include <gtk/gtkwindow.h>
#endif
"
perl -0777 -p -i -e "s%\Q$i\E%%s" final.h

i="\
#ifndef GDK_DISABLE_DEPRECATION_WARNINGS
#if GDK_VERSION_MIN_REQUIRED >= GDK_VERSION_3_10
G_DEPRECATED
#endif
#endif
"
perl -0777 -p -i -e "s%\Q$i\E%%s" final.h

i="\
#define gtk_major_version gtk_get_major_version ()
#define gtk_minor_version gtk_get_minor_version ()
#define gtk_micro_version gtk_get_micro_version ()
#define gtk_binary_age gtk_get_binary_age ()
#define gtk_interface_age gtk_get_interface_age ()
"
j="\
#define gtk_major_version() gtk_get_major_version ()
#define gtk_minor_version() gtk_get_minor_version ()
#define gtk_micro_version() gtk_get_micro_version ()
#define gtk_binary_age() gtk_get_binary_age ()
#define gtk_interface_age() gtk_get_interface_age ()
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.h

# no direct bitfield support in nimrod
i="\
struct GtkAccelKey
{
  guint           accel_key;
  GdkModifierType accel_mods;
  guint           accel_flags : 16;
};
"
j="\
struct GtkAccelKey
{
  guint           accel_key;
  GdkModifierType accel_mods;
  guint           accel_flags;
};
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.h

i="\
struct GtkWidgetAuxInfo
{
  gint width;
  gint height;

  guint   halign : 4;
  guint   valign : 4;

  GtkBorder margin;
};
"
j="\
struct GtkWidgetAuxInfo
{
  gint width;
  gint height;
  guint   halign4valign4;
  GtkBorder margin;
};
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.h

# remove these macros for now
i="\
#define gtk_widget_class_bind_template_callback(widget_class, callback) \\
  gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (widget_class), \\
                                                #callback, \\
                                                G_CALLBACK (callback))
"
j="\
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.h

i="\
#define gtk_widget_class_bind_template_child(widget_class, TypeName, member_name) \\
  gtk_widget_class_bind_template_child_full (widget_class, \\
                                             #member_name, \\
                                             FALSE, \\
                                             G_STRUCT_OFFSET (TypeName, member_name))
"
j="\
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.h

i="\
#define gtk_widget_class_bind_template_child_internal(widget_class, TypeName, member_name) \\
  gtk_widget_class_bind_template_child_full (widget_class, \\
                                             #member_name, \\
                                             TRUE, \\
                                             G_STRUCT_OFFSET (TypeName, member_name))
"
j="\
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.h

i="\
#define gtk_widget_class_bind_template_child_private(widget_class, TypeName, member_name) \\
  gtk_widget_class_bind_template_child_full (widget_class, \\
                                             #member_name, \\
                                             FALSE, \\
                                             G_PRIVATE_OFFSET (TypeName, member_name))
"
j="\
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.h

i="\
#define gtk_widget_class_bind_template_child_internal_private(widget_class, TypeName, member_name) \\
  gtk_widget_class_bind_template_child_full (widget_class, \\
                                             #member_name, \\
                                             TRUE, \\
                                             G_PRIVATE_OFFSET (TypeName, member_name))
"
j="\
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.h

# more bitfield
i="\
  \/*< private >*\/

  unsigned int _handle_border_width : 1;

  \/* Padding for future expansion *\/
  void (*_gtk_reserved1) (void);
"
j="\
  unsigned int _handle_border_width;
  void (*_gtk_reserved1) (void);
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.h

i="\
struct GtkMenuShellClass
{
  GtkContainerClass parent_class;

  guint submenu_placement : 1;

  void     (*deactivate)       (GtkMenuShell *menu_shell);
"
j="\
struct GtkMenuShellClass
{
  GtkContainerClass parent_class;
  guint submenu_placement;
  void     (*deactivate)       (GtkMenuShell *menu_shell);
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.h

i="\
struct GtkTextAppearance
{
  /*< public >*/
  GdkColor bg_color;
  GdkColor fg_color;

  /* super/subscript rise, can be negative */
  gint rise;

  guint underline : 4;          /* PangoUnderline */
  guint strikethrough : 1;

  /* Whether to use background-related values; this is irrelevant for
   * the values struct when in a tag, but is used for the composite
   * values struct; it's true if any of the tags being composited
   * had background stuff set.
   */
  guint draw_bg : 1;

  /* These are only used when we are actually laying out and rendering
   * a paragraph; not when a GtkTextAppearance is part of a
   * GtkTextAttributes.
   */
  guint inside_selection : 1;
  guint is_text : 1;

  /* For the sad story of this bit of code, see
   * https://bugzilla.gnome.org/show_bug.cgi?id=711158
   */
#ifdef __GI_SCANNER__
  /* The scanner should only see the transparent union, so that its
   * content does not vary across architectures.
   */
  union {
    GdkRGBA *rgba[2];
    /*< private >*/
    guint padding[4];
  };
#else
  GdkRGBA *rgba[2];
#if (defined(__SIZEOF_INT__) && defined(__SIZEOF_POINTER__)) && (__SIZEOF_INT__ == __SIZEOF_POINTER__)
  /* unusable, just for ABI compat */
  /*< private >*/
  guint padding[2];
#endif
#endif
};
"
j="\
struct GtkTextAppearance
{
  GdkColor bg_color;
  GdkColor fg_color;
  gint rise;
  guint bitfield0_GtkTextAppearance;
  GdkRGBA *rgba[2];
};
"
perl -0777 -p -i -e "s%\Q$i\E%$j%s" final.h

i="\
struct GtkTextAttributes
{
  /*< private >*/
  guint refcount;

  /*< public >*/
  GtkTextAppearance appearance;

  GtkJustification justification;
  GtkTextDirection direction;

  /* Individual chunks of this can be set/unset as a group */
  PangoFontDescription *font;

  gdouble font_scale;

  gint left_margin;
  gint right_margin;
  gint indent;

  gint pixels_above_lines;
  gint pixels_below_lines;
  gint pixels_inside_wrap;

  PangoTabArray *tabs;

  GtkWrapMode wrap_mode;        /* How to handle wrap-around for this tag.
                                 * Must be GTK_WRAPMODE_CHAR,
                                 * GTK_WRAPMODE_NONE, GTK_WRAPMODE_WORD
                                 */

  PangoLanguage *language;

  /*< private >*/
  /* Paragraph background */
  GdkColor *pg_bg_color;

  /*< public >*/
  /* hide the text  */
  guint invisible : 1;

  /* Background is fit to full line height rather than
   * baseline +/- ascent/descent (font height)
   */
  guint bg_full_height : 1;

  /* can edit this text */
  guint editable : 1;

  /*< private >*/
  /* Paragraph background */
  GdkRGBA *pg_bg_rgba;

  guint padding[3];
};
"
j="\
struct GtkTextAttributes
{
  guint refcount;
  GtkTextAppearance appearance;
  GtkJustification justification;
  GtkTextDirection direction;
  PangoFontDescription *font;
  gdouble font_scale;
  gint left_margin;
  gint right_margin;
  gint indent;
  gint pixels_above_lines;
  gint pixels_below_lines;
  gint pixels_inside_wrap;
  PangoTabArray *tabs;
  GtkWrapMode wrap_mode;
  PangoLanguage *language;
  GdkColor *pg_bg_color;
  guint bitfield111;
  GdkRGBA *pg_bg_rgba;
  guint padding[3];
};
"
perl -0777 -p -i -e "s%\Q$i\E%$j%s" final.h

i="\
struct GtkBindingSet
{
  gchar           *set_name;
  gint             priority;
  GSList          *widget_path_pspecs;
  GSList          *widget_class_pspecs;
  GSList          *class_branch_pspecs;
  GtkBindingEntry *entries;
  GtkBindingEntry *current;
  guint            parsed : 1;
};
"
j="\
struct GtkBindingSet
{
  gchar           *set_name;
  gint             priority;
  GSList          *widget_path_pspecs;
  GSList          *widget_class_pspecs;
  GSList          *class_branch_pspecs;
  GtkBindingEntry *entries;
  GtkBindingEntry *current;
  guint            parsed;
};
"
perl -0777 -p -i -e "s%\Q$i\E%$j%s" final.h

i="\
struct GtkBindingEntry
{
  /* key portion */
  guint             keyval;
  GdkModifierType   modifiers;

  GtkBindingSet    *binding_set;
  guint             destroyed     : 1;
  guint             in_emission   : 1;
  guint             marks_unbound : 1;
  GtkBindingEntry  *set_next;
  GtkBindingEntry  *hash_next;
  GtkBindingSignal *signals;
};
"
j="\
struct GtkBindingEntry
{
  guint             keyval;
  GdkModifierType   modifiers;
  GtkBindingSet    *binding_set;
  guint             bitfield111;
  GtkBindingEntry  *set_next;
  GtkBindingEntry  *hash_next;
  GtkBindingSignal *signals;
};
"
perl -0777 -p -i -e "s%\Q$i\E%$j%s" final.h

i="\
struct GtkBindingArg
{
  GType      arg_type;
  union {
    glong    long_data;
    gdouble  double_data;
    gchar   *string_data;
  } d;
};
"
j="\
  union dummy_union_name {
    glong    long_data;
    gdouble  double_data;
    gchar   *string_data;
  };
struct GtkBindingArg
{
  GType      arg_type;
	dummy_union_name d;
};
"
perl -0777 -p -i -e "s%\Q$i\E%$j%s" final.h

i="\
struct GtkMenuItemClass
{
  GtkBinClass parent_class;

  /*< public >*/

  /* If the following flag is true, then we should always
   * hide the menu when the MenuItem is activated. Otherwise,
   * it is up to the caller. For instance, when navigating
   * a menu with the keyboard, <Space> doesn't hide, but
   * <Return> does.
   */
  guint hide_on_activate : 1;

  void (* activate)             (GtkMenuItem *menu_item);
"
j="\
struct GtkMenuItemClass
{
  GtkBinClass parent_class;
  guint hide_on_activate;
  void (* activate)             (GtkMenuItem *menu_item);
"
perl -0777 -p -i -e "s%\Q$i\E%$j%s" final.h

i="\
#ifdef G_ENABLE_DEBUG

#define GTK_NOTE(type,action)                G_STMT_START { \\
    if (gtk_get_debug_flags () & GTK_DEBUG_##type)		    \\
       { action; };                          } G_STMT_END

#else /* !G_ENABLE_DEBUG */

#define GTK_NOTE(type, action)

#endif /* G_ENABLE_DEBUG */
"
j="\
"
perl -0777 -p -i -e "s%\Q$i\E%$j%s" final.h


i="\
  GSList *icon_factories;

  guint engine_specified : 1;   /* The RC file specified the engine */
};
"
j="\
  GSList *icon_factories;
  guint engine_specified;
};
"
perl -0777 -p -i -e "s%\Q$i\E%$j%s" final.h

i="\
struct GtkTableChild
{
  GtkWidget *widget;
  guint16 left_attach;
  guint16 right_attach;
  guint16 top_attach;
  guint16 bottom_attach;
  guint16 xpadding;
  guint16 ypadding;
  guint xexpand : 1;
  guint yexpand : 1;
  guint xshrink : 1;
  guint yshrink : 1;
  guint xfill : 1;
  guint yfill : 1;
};

struct GtkTableRowCol
{
  guint16 requisition;
  guint16 allocation;
  guint16 spacing;
  guint need_expand : 1;
  guint need_shrink : 1;
  guint expand : 1;
  guint shrink : 1;
  guint empty : 1;
};
"
j="\
struct GtkTableChild
{
  GtkWidget *widget;
  guint16 left_attach;
  guint16 right_attach;
  guint16 top_attach;
  guint16 bottom_attach;
  guint16 xpadding;
  guint16 ypadding;
  guint bitfield6;
};

struct GtkTableRowCol
{
  guint16 requisition;
  guint16 allocation;
  guint16 spacing;
  guint bitfield5;
};
"
perl -0777 -p -i -e "s%\Q$i\E%$j%s" final.h

# no #endif because we do not use #ifdef a11y
#echo "#endif" >> final.h

c2nim --skipcomments --skipinclude $final

ruby ../remdef.rb final.nim

sed -i '1d' final.nim
sed -i 's/^  //' final.nim

ruby ../temp_fix.rb final.nim

sed  -i "s/_gtk_reserved\(1\?[0-9]\)\*: proc () {\.cdecl\.}/ugtk_reserved\1\*: proc () {\.cdecl\.}/g" final.nim

ruby ../mangler.rb final.nim GTK_

ruby ../mangler.rb final.nim Gtk

# For these names conflicts occur when removing Gdk prefix
# later we may manually fix a few more prefixes with care
for i in Visual Window Atom Display Cursor Screen Broadway; do
  sed -i "s/Gdk$i/XGXdXk$i/g" final.nim
done
ruby ../mangler.rb final.nim Gdk
for i in Visual Window Atom Display Cursor Screen Broadway; do
  sed -i "s/XGXdXk$i/Gdk$i/g" final.nim
done

sed -i "2iimport" final.nim
sed -i "3i\  glib2, atk, gdk3, gdk2pixbuf, pango, cairo" final.nim
sed -i "4iconst" final.nim
sed -i "5i\  GFALSE* = gboolean(0)" final.nim
sed -i "6i\  GTRUE* = gboolean(\`not\`(GFALSE))" final.nim

sed  -i "s/: ptr /: P/g" final.nim
sed  -i "s/: Pptr /: ptr P/g" final.nim

i="\
type 
  JunctionSides* {.size: sizeof(cint).} = enum 
    JUNCTION_NONE = 0, JUNCTION_CORNER_TOPLEFT = 1 shl 0, 
    JUNCTION_CORNER_TOPRIGHT = 1 shl 1, 
    JUNCTION_CORNER_BOTTOMLEFT = 1 shl 2, 
    JUNCTION_CORNER_BOTTOMRIGHT = 1 shl 3, JUNCTION_TOP = (
        JUNCTION_CORNER_TOPLEFT or JUNCTION_CORNER_TOPRIGHT), JUNCTION_BOTTOM = (
        JUNCTION_CORNER_BOTTOMLEFT or JUNCTION_CORNER_BOTTOMRIGHT), JUNCTION_LEFT = (
        JUNCTION_CORNER_TOPLEFT or JUNCTION_CORNER_BOTTOMLEFT), JUNCTION_RIGHT = (
        JUNCTION_CORNER_TOPRIGHT or JUNCTION_CORNER_BOTTOMRIGHT)
"
j="\
type 
  JunctionSides* {.size: sizeof(cint).} = enum 
    JUNCTION_NONE = 0,
    JUNCTION_CORNER_TOPLEFT = 1 shl 0, 
    JUNCTION_CORNER_TOPRIGHT = 1 shl 1, 
    #JUNCTION_TOP = (JUNCTION_CORNER_TOPLEFT or JUNCTION_CORNER_TOPRIGHT),
    JUNCTION_TOP = (1 shl 0) or (1 shl 1),
    JUNCTION_CORNER_BOTTOMLEFT = 1 shl 2,
    #JUNCTION_LEFT = (JUNCTION_CORNER_TOPLEFT or JUNCTION_CORNER_BOTTOMLEFT),
    JUNCTION_LEFT = (1 shl 0) or (1 shl 2),
    JUNCTION_CORNER_BOTTOMRIGHT = 1 shl 3,
    JUNCTION_RIGHT = (1 shl 1) or (1 shl 3)
    JUNCTION_BOTTOM = (1 shl 2) or (1 shl 3),
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
template ACCEL_GROUP_TEMPLATE*(object: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((object), TYPE_ACCEL_GROUP, AccelGroup))
"
j="\
template ACCEL_GROUP_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_ACCEL_GROUP, AccelGroup))
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
template IS_ACCEL_GROUP*(object: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((object), TYPE_ACCEL_GROUP))
"
j="\
template IS_ACCEL_GROUP*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_ACCEL_GROUP))
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

ruby ../gen_ptr.rb final.nim
ruby ../fixT.rb final.nim

i="\
type 
  AccelGroupActivate* = proc (accel_group: PAccelGroup; 
                                 acceleratable: PGObject; keyval: guint; 
                                 modifier: ModifierType): gboolean {.cdecl.}
type 
  AccelGroupFindFunc* = proc (key: PAccelKey; closure: PGClosure; 
                                 data: gpointer): gboolean {.cdecl.}
type 
  PAccelGroup* = ptr TAccelGroup
  TAccelGroup* = object 
    parent*: GObject
    priv*: PAccelGroupPrivate

type 
  PAccelGroupClass* = ptr TAccelGroupClass
  TAccelGroupClass* = object 
    parent_class*: GObjectClass
    accel_changed*: proc (accel_group: PAccelGroup; keyval: guint; 
                          modifier: ModifierType; 
                          accel_closure: PGClosure) {.cdecl.}
    ugtk_reserved1*: proc () {.cdecl.}
    ugtk_reserved2*: proc () {.cdecl.}
    ugtk_reserved3*: proc () {.cdecl.}
    ugtk_reserved4*: proc () {.cdecl.}

type 
  PAccelKey* = ptr TAccelKey
  TAccelKey* = object 
    accel_key*: guint
    accel_mods*: ModifierType
    accel_flags*: guint

"
j="\
type 
  PAccelGroup* = ptr TAccelGroup
  TAccelGroup* = object 
    parent*: GObject
    priv*: PAccelGroupPrivate

type 
  PAccelGroupClass* = ptr TAccelGroupClass
  TAccelGroupClass* = object 
    parent_class*: GObjectClass
    accel_changed*: proc (accel_group: PAccelGroup; keyval: guint; 
                          modifier: ModifierType; 
                          accel_closure: PGClosure) {.cdecl.}
    ugtk_reserved1*: proc () {.cdecl.}
    ugtk_reserved2*: proc () {.cdecl.}
    ugtk_reserved3*: proc () {.cdecl.}
    ugtk_reserved4*: proc () {.cdecl.}

type 
  PAccelKey* = ptr TAccelKey
  TAccelKey* = object 
    accel_key*: guint
    accel_mods*: ModifierType
    accel_flags*: guint

type 
  AccelGroupActivate* = proc (accel_group: PAccelGroup; 
                                 acceleratable: PGObject; keyval: guint; 
                                 modifier: ModifierType): gboolean {.cdecl.}
type 
  AccelGroupFindFunc* = proc (key: PAccelKey; closure: PGClosure; 
                                 data: gpointer): gboolean {.cdecl.}

"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

sed  -i "s/ GObject$/ TGObject/g" final.nim
sed  -i "s/ GObjectClass$/ TGObjectClass/g" final.nim

sed  -i "s/ ModifierType/ gdk2.TModifierType/g" final.nim

sed  -i "s/Pgchar/CSTRING/g" final.nim

sed  -i "s/GQuark/TGQuark/g" final.nim

sed  -i "s/proc _gtk/proc underscore_gtk/g" final.nim

sed  -i "s/object: PGObject)/obj: PGObject)/g" final.nim
sed  -i "s/object: PGObject;/obj: PGObject;/g" final.nim

i="\
proc gtk_accel_group_query*(accel_group: PAccelGroup; accel_key: guint; 
                            accel_mods: gdk2.TModifierType; n_entries: Pguint): PAccelGroupEntry {.
    cdecl, importc: \"gtk_accel_group_query\", dynlib: lib.}
type 
  PAccelGroupEntry* = ptr TAccelGroupEntry
  TAccelGroupEntry* = object 
    key*: TAccelKey
    closure*: PGClosure
    accel_path_quark*: TGQuark
"
j="\
type 
  PAccelGroupEntry* = ptr TAccelGroupEntry
  TAccelGroupEntry* = object 
    key*: TAccelKey
    closure*: PGClosure
    accel_path_quark*: TGQuark
proc gtk_accel_group_query*(accel_group: PAccelGroup; accel_key: guint; 
                            accel_mods: gdk2.TModifierType; n_entries: Pguint): PAccelGroupEntry {.
    cdecl, importc: \"gtk_accel_group_query\", dynlib: lib.}
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

sed  -i "s/border_: PBorder)/border: PBorder)/g" final.nim

i="\
type 
  PBuilder* = ptr TBuilder
  TBuilder* = object 
    parent_instance*: TGObject
    priv*: PBuilderPrivate
"
j="\
  BuilderConnectFunc* = proc (builder: PBuilder; obj: PGObject; 
                                 signal_name: CSTRING; 
                                 handler_name: CSTRING; 
                                 connect_obj: PGObject; 
                                 flags: GConnectFlags; user_data: gpointer) {.
      cdecl.}
"
perl -0777 -p -i -e "s/\Q$i\E//s" final.nim
perl -0777 -p -i -e "s/\Q$j\E/$i$j/s" final.nim

sed  -i "s/flags: GConnectFlags; user_data: gpointer)/flags: TGConnectFlags; user_data: gpointer)/g" final.nim

sed  -i "s/Allocation\* = Rectangle/PAllocation\* = PRectangle\n  TAllocation\* = gdk3.TRectangle/g" final.nim

i="\
type 
  Callback* = proc (widget: PWidget; data: gpointer) {.cdecl.}
type 
  TickCallback* = proc (widget: PWidget; 
                           frame_clock: PFrameClock; user_data: gpointer): gboolean {.
      cdecl.}
type 
  PRequisition* = ptr TRequisition
  TRequisition* = object 
    width*: gint
    height*: gint

type 
  PWidget* = ptr TWidget
  TWidget* = object 
    parent_instance*: GInitiallyUnowned
    priv*: PWidgetPrivate
"
j="\
type 
  PRequisition* = ptr TRequisition
  TRequisition* = object 
    width*: gint
    height*: gint

type 
  PWidget* = ptr TWidget
  TWidget* = object 
    parent_instance*: GInitiallyUnowned
    priv*: PWidgetPrivate
type 
  Callback* = proc (widget: PWidget; data: gpointer) {.cdecl.}
type 
  TickCallback* = proc (widget: PWidget; 
                           frame_clock: PFrameClock; user_data: gpointer): gboolean {.
      cdecl.}
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

sed  -i "s/ GInitiallyUnowned/ TGInitiallyUnowned/g" final.nim

sed  -i "s/ time_: guint/ time: guint/g" final.nim

sed  -i "s/Pcairo_t/cairo.Pcontext/g" final.nim
sed  -i "s/PPangoContext/pango.Pcontext/g" final.nim
sed  -i "s/PPangoLayout/Playout/g" final.nim
sed  -i "s/Pcairo_region_t/Pregion/g" final.nim
sed  -i "s/EventMask/TEventMask/g" final.nim

sed  -i "s/ type: / typ: /g" final.nim
sed  -i "s/(type: /(typ: /g" final.nim
sed  -i "s/PRectangle/gdk2.PRectangle/g" final.nim

i="\
type 
  PSettings* = ptr TSettings
  TSettings* = object 
    parent_instance*: TGObject
    priv*: PSettingsPrivate
"
j="\
type 
  PWidgetAuxInfo* = ptr TWidgetAuxInfo
  TWidgetAuxInfo* = object 
    width*: gint
    height*: gint
    halign4valign4*: guint
    margin*: TBorder
"

perl -0777 -p -i -e "s/\Q$i\E//s" final.nim
perl -0777 -p -i -e "s/\Q$j\E/$j$i/s" final.nim

sed  -i "s/ GdkAtom/ TGdkAtom/g" final.nim
sed  -i "s/: GApplication/: TGApplication/g" final.nim
sed  -i "s/: GCallback/: TGCallback/g" final.nim
sed  -i "s/ AtkRole/ TAtkRole/g" final.nim
sed  -i "s/ ModifierIntent/ TModifierIntent/g" final.nim
sed  -i "s/: GDestroyNotify/: TGDestroyNotify/g" final.nim

sed  -i "s/_handle_border_width\*: cuint/handle_border_width\*: cuint/g" final.nim

i="\
type 
  PAdjustment* = ptr TAdjustment
  TAdjustment* = object 
    parent_instance*: TGInitiallyUnowned
    priv*: PAdjustmentPrivate
"
j="\
type 
  PContainer* = ptr TContainer
  TContainer* = object 
    widget*: TWidget
    priv*: PContainerPrivate
"

perl -0777 -p -i -e "s/\Q$i\E//s" final.nim
perl -0777 -p -i -e "s/\Q$j\E/$j$i/s" final.nim

i="\
template CONTAINER_WARN_INVALID_CHILD_PROPERTY_ID*(
    object, property_id, pspec: expr): expr = 
  G_OBJECT_WARN_INVALID_PSPEC((object), \"child property\", (property_id), 
                              (pspec))
"
j="\
template CONTAINER_WARN_INVALID_CHILD_PROPERTY_ID*(
    obj, property_id, pspec: expr): expr = 
  G_OBJECT_WARN_INVALID_PSPEC((obj), \"child property\", (property_id), 
                              (pspec))
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
template WINDOW_GROUP_TEMPLATE*(object: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((object), TYPE_WINDOW_GROUP, TWindowGroup))

template WINDOW_GROUP_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_WINDOW_GROUP, TWindowGroupClass))

template IS_WINDOW_GROUP*(object: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((object), TYPE_WINDOW_GROUP))
"
j="\
template WINDOW_GROUP_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_WINDOW_GROUP, TWindowGroup))

template WINDOW_GROUP_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_WINDOW_GROUP, TWindowGroupClass))

template IS_WINDOW_GROUP*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_WINDOW_GROUP))
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

sed  -i "s/: Gravity/: TGravity/g" final.nim
sed  -i "s/: GdkWindowHints/: TWindowHints/g" final.nim
sed  -i "s/: GdkWindowEdge/: TWindowEdge/g" final.nim

i="\
type 
  ResponseType* {.size: sizeof(cint).} = enum 
    RESPONSE_NONE = - 1, RESPONSE_REJECT = - 2, 
    RESPONSE_ACCEPT = - 3, RESPONSE_DELETE_EVENT = - 4, 
    RESPONSE_OK = - 5, RESPONSE_CANCEL = - 6, 
    RESPONSE_CLOSE = - 7, RESPONSE_YES = - 8, RESPONSE_NO = - 9, 
    RESPONSE_APPLY = - 10, RESPONSE_HELP = - 11
"
j="\
type 
  ResponseType* {.size: sizeof(cint).} = enum 
    RESPONSE_HELP = - 11
    RESPONSE_APPLY = - 10,
    RESPONSE_NO = - 9, 
    RESPONSE_YES = - 8,
    RESPONSE_CLOSE = - 7,
    RESPONSE_CANCEL = - 6, 
    RESPONSE_OK = - 5,
    RESPONSE_DELETE_EVENT = - 4, 
    RESPONSE_ACCEPT = - 3,
    RESPONSE_REJECT = - 2, 
    RESPONSE_NONE = - 1,
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
template ABOUT_DIALOG_TEMPLATE*(object: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((object), TYPE_ABOUT_DIALOG, TAboutDialog))

template ABOUT_DIALOG_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_ABOUT_DIALOG, TAboutDialogClass))

template IS_ABOUT_DIALOG*(object: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((object), TYPE_ABOUT_DIALOG))
"
j="\
template ABOUT_DIALOG_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_ABOUT_DIALOG, TAboutDialog))

template ABOUT_DIALOG_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_ABOUT_DIALOG, TAboutDialogClass))

template IS_ABOUT_DIALOG*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_ABOUT_DIALOG))
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  MenuPositionFunc* = proc (menu: PMenu; x: Pgint; y: Pgint; 
                               push_in: Pgboolean; user_data: gpointer) {.
      cdecl.}
type 
  MenuDetachFunc* = proc (attach_widget: PWidget; menu: PMenu) {.
      cdecl.}
type 
  PMenu* = ptr TMenu
  TMenu* = object 
    menu_shell*: TMenuShell
    priv*: PMenuPrivate
"
j="\
type 
  PMenu* = ptr TMenu
  TMenu* = object 
    menu_shell*: TMenuShell
    priv*: PMenuPrivate
type 
  MenuPositionFunc* = proc (menu: PMenu; x: Pgint; y: Pgint; 
                               push_in: Pgboolean; user_data: gpointer) {.
      cdecl.}
type 
  MenuDetachFunc* = proc (attach_widget: PWidget; menu: PMenu) {.
      cdecl.}
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

sed  -i "s/: PPangoAttrList/: PAttrList/g" final.nim

sed  -i "s/: PangoEllipsizeMode/: TEllipsizeMode/g" final.nim
sed  -i "s/: PangoWrapMode/: TWrapMode/g" final.nim

i="\
proc gtk_label_get_selection_bounds*(label: PLabel; start: Pgint; 
                                     end: Pgint): gboolean {.cdecl, 
    importc: \"gtk_label_get_selection_bounds\", dynlib: lib.}
"
j="\
proc gtk_label_get_selection_bounds*(label: PLabel; start: Pgint; 
                                     e: Pgint): gboolean {.cdecl, 
    importc: \"gtk_label_get_selection_bounds\", dynlib: lib.}
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

sed  -i "s/ AtkObject/ TAtkObject/g" final.nim
sed  -i "s/: GTypeInterface/: TGTypeInterface/g" final.nim

i="\
proc gtk_box_query_child_packing*(box: PBox; child: PWidget; 
                                  expand: Pgboolean; fill: Pgboolean; 
                                  padding: Pguint; 
                                  pack_type: PPackType) {.cdecl, 
    importc: \"gtk_box_query_child_packing\", dynlib: lib.}
"
j="\
proc gtk_box_query_child_packing*(box: PBox; child: PWidget; 
                                  expand: Pgboolean; fill: Pgboolean; 
                                  padding: Pguint; 
                                  pack_type: var PackType) {.cdecl, 
    importc: \"gtk_box_query_child_packing\", dynlib: lib.}
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  TreeModelForeachFunc* = proc (model: PTreeModel; 
                                   path: PTreePath; 
                                   iter: PTreeIter; data: gpointer): gboolean {.
      cdecl.}
type 
  TreeModelFlags* {.size: sizeof(cint).} = enum 
    TREE_MODEL_ITERS_PERSIST = 1 shl 0, TREE_MODEL_LIST_ONLY = 1 shl
        1
type 
  PTreeIter* = ptr TTreeIter
  TTreeIter* = object 
    stamp*: gint
    user_data*: gpointer
    user_data2*: gpointer
    user_data3*: gpointer
"
j="\
type 
  PTreeIter* = ptr TTreeIter
  TTreeIter* = object 
    stamp*: gint
    user_data*: gpointer
    user_data2*: gpointer
    user_data3*: gpointer

type 
  TreeModelForeachFunc* = proc (model: PTreeModel; 
                                   path: PTreePath; 
                                   iter: PTreeIter; data: gpointer): gboolean {.
      cdecl.}
type 
  TreeModelFlags* {.size: sizeof(cint).} = enum 
    TREE_MODEL_ITERS_PERSIST = 1 shl 0, TREE_MODEL_LIST_ONLY = 1 shl
        1
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

sed  -i "s/index_: gint)/index: gint)/g" final.nim

i="\
    get_sort_column_id*: proc (sortable: PTreeSortable; 
                               sort_column_id: Pgint; 
                               order: PSortType): gboolean {.cdecl.}
"
j="\
    get_sort_column_id*: proc (sortable: PTreeSortable; 
                               sort_column_id: Pgint; 
                               order: var SortType): gboolean {.cdecl.}
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
proc gtk_tree_sortable_get_sort_column_id*(sortable: PTreeSortable; 
    sort_column_id: Pgint; order: PSortType): gboolean {.cdecl, 
    importc: \"gtk_tree_sortable_get_sort_column_id\", dynlib: lib.}
"
j="\
proc gtk_tree_sortable_get_sort_column_id*(sortable: PTreeSortable; 
    sort_column_id: Pgint; order: var SortType): gboolean {.cdecl, 
    importc: \"gtk_tree_sortable_get_sort_column_id\", dynlib: lib.}
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
template CELL_AREA_WARN_INVALID_CELL_PROPERTY_ID*(
    object, property_id, pspec: expr): expr = 
  G_OBJECT_WARN_INVALID_PSPEC((object), \"cell property id\", (property_id), 
                              (pspec))
"
j="\
template CELL_AREA_WARN_INVALID_CELL_PROPERTY_ID*(
    obj, property_id, pspec: expr): expr = 
  G_OBJECT_WARN_INVALID_PSPEC((obj), \"cell property id\", (property_id), 
                              (pspec))
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

sed  -i "s/ GFunc/ TGFunc/g" final.nim

i="\
template TREE_VIEW_COLUMN*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_TREE_VIEW_COLUMN, 
                              TTreeViewColumn))

template TREE_VIEW_COLUMN_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_TREE_VIEW_COLUMN, 
                           TTreeViewColumnClass))

template IS_TREE_VIEW_COLUMN*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_TREE_VIEW_COLUMN))

template IS_TREE_VIEW_COLUMN_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_TREE_VIEW_COLUMN))

template TREE_VIEW_COLUMN_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_TREE_VIEW_COLUMN, 
                             TTreeViewColumnClass))

type 
  TreeViewColumnSizing* {.size: sizeof(cint).} = enum 
    TREE_VIEW_COLUMN_GROW_ONLY, TREE_VIEW_COLUMN_AUTOSIZE, 
    TREE_VIEW_COLUMN_FIXED
type 
  TreeCellDataFunc* = proc (tree_column: PTreeViewColumn; 
                               cell: PCellRenderer; 
                               tree_model: PTreeModel; 
                               iter: PTreeIter; data: gpointer) {.cdecl.}
type 
  PTreeViewColumn* = ptr TTreeViewColumn
  TTreeViewColumn* = object 
    parent_instance*: TGInitiallyUnowned
    priv*: PTreeViewColumnPrivate

type 
  PTreeViewColumnClass* = ptr TTreeViewColumnClass
  TTreeViewColumnClass* = object 
    parent_class*: TGInitiallyUnownedClass
    clicked*: proc (tree_column: PTreeViewColumn) {.cdecl.}
    ugtk_reserved1*: proc () {.cdecl.}
    ugtk_reserved2*: proc () {.cdecl.}
    ugtk_reserved3*: proc () {.cdecl.}
    ugtk_reserved4*: proc () {.cdecl.}

"
j="\
type 
  PTreeViewColumn* = ptr TTreeViewColumn
  TTreeViewColumn* = object 
    parent_instance*: TGInitiallyUnowned
    priv*: PTreeViewColumnPrivate

type 
  PTreeViewColumnClass* = ptr TTreeViewColumnClass
  TTreeViewColumnClass* = object 
    parent_class*: TGInitiallyUnownedClass
    clicked*: proc (tree_column: PTreeViewColumn) {.cdecl.}
    ugtk_reserved1*: proc () {.cdecl.}
    ugtk_reserved2*: proc () {.cdecl.}
    ugtk_reserved3*: proc () {.cdecl.}
    ugtk_reserved4*: proc () {.cdecl.}

template TREE_VIEW_COLUMN*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_TREE_VIEW_COLUMN, 
                              TTreeViewColumn))

template TREE_VIEW_COLUMN_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_TREE_VIEW_COLUMN, 
                           TTreeViewColumnClass))

template IS_TREE_VIEW_COLUMN*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_TREE_VIEW_COLUMN))

template IS_TREE_VIEW_COLUMN_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_TREE_VIEW_COLUMN))

template TREE_VIEW_COLUMN_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_TREE_VIEW_COLUMN, 
                             TTreeViewColumnClass))

type 
  TreeViewColumnSizing* {.size: sizeof(cint).} = enum 
    TREE_VIEW_COLUMN_GROW_ONLY, TREE_VIEW_COLUMN_AUTOSIZE, 
    TREE_VIEW_COLUMN_FIXED
type 
  TreeCellDataFunc* = proc (tree_column: PTreeViewColumn; 
                               cell: PCellRenderer; 
                               tree_model: PTreeModel; 
                               iter: PTreeIter; data: gpointer) {.cdecl.}
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

sed  -i "s/: Color /: gdk2.TColor /g" final.nim
sed  -i "s/: Color)/: gdk2.TColor)/g" final.nim
sed  -i "s/: Color$/: gdk2.TColor/g" final.nim
sed  -i "s/: PColor)/: gdk2.PColor)/g" final.nim
sed  -i "s/: PColor$/: gdk2.PColor/g" final.nim

i="\
template TEXT_CHILD_ANCHOR*(object: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((object), TYPE_TEXT_CHILD_ANCHOR, 
                              TTextChildAnchor))
"
j="\
template TEXT_CHILD_ANCHOR*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_TEXT_CHILD_ANCHOR, 
                              TTextChildAnchor))
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

sed  -i "s/rgba\*: array\[2, ptr RGBA\]/rgba\*: array\[2, PRGBA\]/g" final.nim

sed  -i "s/: PPangoTabArray/: PTabArray/g" final.nim
sed  -i "s/: PPangoLanguage/: PLanguage/g" final.nim

i="\
template IS_TEXT_CHILD_ANCHOR*(object: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((object), TYPE_TEXT_CHILD_ANCHOR))
"
j="\
template IS_TEXT_CHILD_ANCHOR*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_TEXT_CHILD_ANCHOR))
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PTextIter* = ptr TTextIter
  TTextIter* = object 
    dummy1*: gpointer
    dummy2*: gpointer
    dummy3*: gint
    dummy4*: gint
    dummy5*: gint
    dummy6*: gint
    dummy7*: gint
    dummy8*: gint
    dummy9*: gpointer
    dummy10*: gpointer
    dummy11*: gint
    dummy12*: gint
    dummy13*: gint
    dummy14*: gpointer
"
j="\
type 
  PTextTag* = ptr TTextTag
  TTextTag* = object 
    parent_instance*: TGObject
    priv*: PTextTagPrivate
"
perl -0777 -p -i -e "s/\Q$i\E//s" final.nim
perl -0777 -p -i -e "s/\Q$j\E/$j$i/s" final.nim

i="\
type 
  PTextBuffer* = ptr TTextBuffer
  TTextBuffer* = object 
    parent_instance*: TGObject
    priv*: PTextBufferPrivate
"
j="\
type 
  TextSearchFlags* {.size: sizeof(cint).} = enum 
    TEXT_SEARCH_VISIBLE_ONLY = 1 shl 0, 
    TEXT_SEARCH_TEXT_ONLY = 1 shl 1, 
    TEXT_SEARCH_CASE_INSENSITIVE = 1 shl 2
"
perl -0777 -p -i -e "s/\Q$i\E//s" final.nim
perl -0777 -p -i -e "s/\Q$j\E/$j$i/s" final.nim

sed  -i "s/ end: PTextIter)/ e: PTextIter)/g" final.nim

sed  -i "s/: DragAction)/: TDragAction)/g" final.nim
sed  -i "s/: DragAction;/: TDragAction;/g" final.nim
sed  -i "s/: DragProtocol;/: TDragProtocol;/g" final.nim

sed  -i "s/Pcairo_surface_t/Psurface/g" final.nim
sed  -i "s/: ptr PPangoAttrList;/: ptr PAttrList;/g" final.nim

i="\
type 
  EntryCompletionMatchFunc* = proc (completion: PEntryCompletion; 
      key: CSTRING; iter: PTreeIter; user_data: gpointer): gboolean {.
      cdecl.}
type 
  PEntryCompletion* = ptr TEntryCompletion
  TEntryCompletion* = object 
    parent_instance*: TGObject
    priv*: PEntryCompletionPrivate
"
j="\
type 
  PEntryCompletion* = ptr TEntryCompletion
  TEntryCompletion* = object 
    parent_instance*: TGObject
    priv*: PEntryCompletionPrivate

type 
  EntryCompletionMatchFunc* = proc (completion: PEntryCompletion; 
      key: CSTRING; iter: PTreeIter; user_data: gpointer): gboolean {.
      cdecl.}
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

sed  -i "s/; index_:/; index:/g" final.nim

i="\
type 
  IconSize* {.size: sizeof(cint).} = enum 
"
j="\
type
  PPIconSize* = ptr PIconSize
  PIconSize* = ptr IconSize
  IconSize* {.size: sizeof(cint).} = enum 
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

j="\
type 
  TreeViewRowSeparatorFunc* = proc (model: PTreeModel; 
      iter: PTreeIter; data: gpointer): gboolean {.cdecl.}
  TreeViewSearchPositionFunc* = proc (tree_view: PTreeView; 
      search_dialog: PWidget; user_data: gpointer) {.cdecl.}
"
i="\
type 
  PTreeSelection* = ptr TTreeSelection
  TTreeSelection* = object 
    parent*: TGObject
    priv*: PTreeSelectionPrivate

type 
  PTreeSelectionClass* = ptr TTreeSelectionClass
  TTreeSelectionClass* = object 
    parent_class*: TGObjectClass
    changed*: proc (selection: PTreeSelection) {.cdecl.}
    ugtk_reserved1*: proc () {.cdecl.}
    ugtk_reserved2*: proc () {.cdecl.}
    ugtk_reserved3*: proc () {.cdecl.}
    ugtk_reserved4*: proc () {.cdecl.}

"
perl -0777 -p -i -e "s/\Q$i\E//s" final.nim
perl -0777 -p -i -e "s/\Q$j\E/$j$i/s" final.nim

i="\
type 
  TreeViewDropPosition* {.size: sizeof(cint).} = enum 
"
j="\
type 
  PTreeViewDropPosition* = ptr TreeViewDropPosition
  TreeViewDropPosition* {.size: sizeof(cint).} = enum 
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

#sed  -i "s/pos: TreeViewDropPosition)/pos: TTreeViewDropPosition)/g" final.nim

i="\
type 
  PBindingSet* = ptr TBindingSet
  TBindingSet* = object 
    set_name*: CSTRING
    priority*: gint
    widget_path_pspecs*: PGSList
    widget_class_pspecs*: PGSList
    class_branch_pspecs*: PGSList
    entries*: PBindingEntry
    current*: PBindingEntry
    parsed*: guint

type 
  PBindingEntry* = ptr TBindingEntry
  TBindingEntry* = object 
    keyval*: guint
    modifiers*: gdk2.TModifierType
    binding_set*: PBindingSet
    bitfield111*: guint
    set_next*: PBindingEntry
    hash_next*: PBindingEntry
    signals*: PBindingSignal

type 
  dummy_union_name* = object  {.union.}
    long_data*: glong
    double_data*: gdouble
    string_data*: CSTRING

type 
  PBindingArg* = ptr TBindingArg
  TBindingArg* = object 
    arg_type*: GType
    d*: dummy_union_name

type 
  PBindingSignal* = ptr TBindingSignal
  TBindingSignal* = object 
    next*: PBindingSignal
    signal_name*: CSTRING
    n_args*: guint
    args*: PBindingArg
"
j="\
type 
  PBindingSet* = ptr TBindingSet
  PBindingEntry* = ptr TBindingEntry
  PBindingArg* = ptr TBindingArg
  PBindingSignal* = ptr TBindingSignal
  TBindingSet* = object 
    set_name*: CSTRING
    priority*: gint
    widget_path_pspecs*: PGSList
    widget_class_pspecs*: PGSList
    class_branch_pspecs*: PGSList
    entries*: PBindingEntry
    current*: PBindingEntry
    parsed*: guint

  TBindingEntry* = object 
    keyval*: guint
    modifiers*: gdk2.TModifierType
    binding_set*: PBindingSet
    bitfield111*: guint
    set_next*: PBindingEntry
    hash_next*: PBindingEntry
    signals*: PBindingSignal

  dummy_union_name* = object  {.union.}
    long_data*: glong
    double_data*: gdouble
    string_data*: CSTRING

  TBindingArg* = object 
    arg_type*: GType
    d*: dummy_union_name

  TBindingSignal* = object 
    next*: PBindingSignal
    signal_name*: CSTRING
    n_args*: guint
    args*: PBindingArg
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

sed  -i "s/: GTokenType/: TGTokenType/g" final.nim

i="\
template BUILDER_WARN_INVALID_CHILD_TYPE*(object, typ: expr): expr = 
  g_warning(\"\'%s\' is not a valid child type of \'%s\'\", type, 
            g_type_name(G_OBJECT_TYPE(object)))
"
j="\
template BUILDER_WARN_INVALID_CHILD_TYPE*(obj, typ: expr): expr = 
  g_warning(\"\'%s\' is not a valid child type of \'%s\'\", type, 
            g_type_name(G_OBJECT_TYPE(obj)))
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
template TYPE_CALENDAR*(): expr = 
  (gtk_calendar_get_type())

template CALENDAR_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_CALENDAR, TCalendar))

template CALENDAR_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_CALENDAR, TCalendarClass))

template IS_CALENDAR*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_CALENDAR))

template IS_CALENDAR_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_CALENDAR))

template CALENDAR_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_CALENDAR, TCalendarClass))

type 
  CalendarDisplayOptions* {.size: sizeof(cint).} = enum 
    CALENDAR_SHOW_HEADING = 1 shl 0, 
    CALENDAR_SHOW_DAY_NAMES = 1 shl 1, 
    CALENDAR_NO_MONTH_CHANGE = 1 shl 2, 
    CALENDAR_SHOW_WEEK_NUMBERS = 1 shl 3, 
    CALENDAR_SHOW_DETAILS = 1 shl 5
type 
  CalendarDetailFunc* = proc (calendar: PCalendar; year: guint; 
                                 month: guint; day: guint; user_data: gpointer): CSTRING {.
      cdecl.}
type 
  PCalendar* = ptr TCalendar
  TCalendar* = object 
    widget*: TWidget
    priv*: PCalendarPrivate

type 
  PCalendarClass* = ptr TCalendarClass
  TCalendarClass* = object 
    parent_class*: TWidgetClass
    month_changed*: proc (calendar: PCalendar) {.cdecl.}
    day_selected*: proc (calendar: PCalendar) {.cdecl.}
    day_selected_double_click*: proc (calendar: PCalendar) {.cdecl.}
    prev_month*: proc (calendar: PCalendar) {.cdecl.}
    next_month*: proc (calendar: PCalendar) {.cdecl.}
    prev_year*: proc (calendar: PCalendar) {.cdecl.}
    next_year*: proc (calendar: PCalendar) {.cdecl.}
    ugtk_reserved1*: proc () {.cdecl.}
    ugtk_reserved2*: proc () {.cdecl.}
    ugtk_reserved3*: proc () {.cdecl.}
    ugtk_reserved4*: proc () {.cdecl.}
"
j="\
type 
  CalendarDisplayOptions* {.size: sizeof(cint).} = enum 
    CALENDAR_SHOW_HEADING = 1 shl 0, 
    CALENDAR_SHOW_DAY_NAMES = 1 shl 1, 
    CALENDAR_NO_MONTH_CHANGE = 1 shl 2, 
    CALENDAR_SHOW_WEEK_NUMBERS = 1 shl 3, 
    CALENDAR_SHOW_DETAILS = 1 shl 5
type 
  PCalendar* = ptr TCalendar
  TCalendar* = object 
    widget*: TWidget
    priv*: PCalendarPrivate

type 
  CalendarDetailFunc* = proc (calendar: PCalendar; year: guint; 
                                 month: guint; day: guint; user_data: gpointer): CSTRING {.
      cdecl.}
type 
  PCalendarClass* = ptr TCalendarClass
  TCalendarClass* = object 
    parent_class*: TWidgetClass
    month_changed*: proc (calendar: PCalendar) {.cdecl.}
    day_selected*: proc (calendar: PCalendar) {.cdecl.}
    day_selected_double_click*: proc (calendar: PCalendar) {.cdecl.}
    prev_month*: proc (calendar: PCalendar) {.cdecl.}
    next_month*: proc (calendar: PCalendar) {.cdecl.}
    prev_year*: proc (calendar: PCalendar) {.cdecl.}
    next_year*: proc (calendar: PCalendar) {.cdecl.}
    ugtk_reserved1*: proc () {.cdecl.}
    ugtk_reserved2*: proc () {.cdecl.}
    ugtk_reserved3*: proc () {.cdecl.}
    ugtk_reserved4*: proc () {.cdecl.}

template TYPE_CALENDAR*(): expr = 
  (gtk_calendar_get_type())

template CALENDAR_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_CALENDAR, TCalendar))

template CALENDAR_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_CALENDAR, TCalendarClass))

template IS_CALENDAR*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_CALENDAR))

template IS_CALENDAR_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_CALENDAR))

template CALENDAR_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_CALENDAR, TCalendarClass))
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

j="\
type 
  PCellArea* = ptr TCellArea
  TCellArea* = object 
    parent_instance*: TGInitiallyUnowned
    priv*: PCellAreaPrivate
"
i="\
type 
  PCellAreaContext* = ptr TCellAreaContext
  TCellAreaContext* = object 
    parent_instance*: TGObject
    priv*: PCellAreaContextPrivate

type 
  PCellAreaContextClass* = ptr TCellAreaContextClass
  TCellAreaContextClass* = object 
    parent_class*: TGObjectClass
    allocate*: proc (context: PCellAreaContext; width: gint; 
                     height: gint) {.cdecl.}
    reset*: proc (context: PCellAreaContext) {.cdecl.}
    get_preferred_height_for_width*: proc (context: PCellAreaContext; 
        width: gint; minimum_height: Pgint; natural_height: Pgint) {.
        cdecl.}
    get_preferred_width_for_height*: proc (context: PCellAreaContext; 
        height: gint; minimum_width: Pgint; natural_width: Pgint) {.
        cdecl.}
    ugtk_reserved1*: proc () {.cdecl.}
    ugtk_reserved2*: proc () {.cdecl.}
    ugtk_reserved3*: proc () {.cdecl.}
    ugtk_reserved4*: proc () {.cdecl.}
    ugtk_reserved5*: proc () {.cdecl.}
    ugtk_reserved6*: proc () {.cdecl.}
"
perl -0777 -p -i -e "s/\Q$i\E//s" final.nim
perl -0777 -p -i -e "s/\Q$j\E/$j$i/s" final.nim

i="\
type 
  FileFilterFunc* = proc (filter_info: PFileFilterInfo; 
                             data: gpointer): gboolean {.cdecl.}
type 
  PFileFilterInfo* = ptr TFileFilterInfo
  TFileFilterInfo* = object 
    contains*: FileFilterFlags
    filename*: CSTRING
    uri*: CSTRING
    display_name*: CSTRING
    mime_type*: CSTRING
"
j="\
type 
  PFileFilterInfo* = ptr TFileFilterInfo
  TFileFilterInfo* = object 
    contains*: FileFilterFlags
    filename*: CSTRING
    uri*: CSTRING
    display_name*: CSTRING
    mime_type*: CSTRING
type 
  FileFilterFunc* = proc (filter_info: PFileFilterInfo; 
                             data: gpointer): gboolean {.cdecl.}
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PFileChooserButtonClass* = ptr TFileChooserButtonClass
  TFileChooserButtonClass* = object 
    parent_class*: TBoxClass
    file_set*: proc (fc: PFileChooserButton) {.cdecl.}
    __gtk_reserved1*: nil
    __gtk_reserved2*: nil
    __gtk_reserved3*: nil
    __gtk_reserved4*: nil

"
j="\
type 
  PFileChooserButtonClass* = ptr TFileChooserButtonClass
  TFileChooserButtonClass* = object 
    parent_class*: TBoxClass
    file_set*: proc (fc: PFileChooserButton) {.cdecl.}
    uugtk_reserved1*: gpointer
    uugtk_reserved2*: gpointer
    uugtk_reserved3*: gpointer
    uugtk_reserved4*: gpointer

"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
    query_tooltip*: proc (status_icon: PStatusIcon; x: gint; y: gint; 
                          keyboard_mode: gboolean; tooltip: PTooltip): gboolean {.
        cdecl.}
    __gtk_reserved1*: nil
    __gtk_reserved2*: nil
    __gtk_reserved3*: nil
    __gtk_reserved4*: nil

"
j="\
    query_tooltip*: proc (status_icon: PStatusIcon; x: gint; y: gint; 
                          keyboard_mode: gboolean; tooltip: PTooltip): gboolean {.
        cdecl.}
    uugtk_reserved1*: gpointer
    uugtk_reserved2*: gpointer
    uugtk_reserved3*: gpointer
    uugtk_reserved4*: gpointer

"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PFlowBoxClass* = ptr TFlowBoxClass
  TFlowBoxClass* = object 
    parent_class*: TContainerClass
    child_activated*: proc (box: PFlowBox; child: PFlowBoxChild) {.
        cdecl.}
    selected_children_changed*: proc (box: PFlowBox) {.cdecl.}
    activate_cursor_child*: proc (box: PFlowBox) {.cdecl.}
    toggle_cursor_child*: proc (box: PFlowBox) {.cdecl.}
    move_cursor*: proc (box: PFlowBox; step: MovementStep; 
                        count: gint) {.cdecl.}
    select_all*: proc (box: PFlowBox) {.cdecl.}
    unselect_all*: proc (box: PFlowBox) {.cdecl.}
    ugtk_reserved1*: proc () {.cdecl.}
    ugtk_reserved2*: proc () {.cdecl.}
    ugtk_reserved3*: proc () {.cdecl.}
    ugtk_reserved4*: proc () {.cdecl.}
    ugtk_reserved5*: proc () {.cdecl.}
    ugtk_reserved6*: proc () {.cdecl.}

template TYPE_FLOW_BOX_CHILD*(): expr = 
  (gtk_flow_box_child_get_type())

template FLOW_BOX_CHILD_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_FLOW_BOX_CHILD, TFlowBoxChild))

template FLOW_BOX_CHILD_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_FLOW_BOX_CHILD, 
                           TFlowBoxChildClass))

template IS_FLOW_BOX_CHILD*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_FLOW_BOX_CHILD))

template IS_FLOW_BOX_CHILD_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_FLOW_BOX_CHILD))

template FLOW_BOX_CHILD_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), EG_TYPE_FLOW_BOX_CHILD, 
                             TFlowBoxChildClass))

type 
  PFlowBoxChild* = ptr TFlowBoxChild
  TFlowBoxChild* = object 
    parent_instance*: TBin
"
j="\
type 
  PFlowBoxChild* = ptr TFlowBoxChild
  TFlowBoxChild* = object 
    parent_instance*: TBin

type 
  PFlowBoxClass* = ptr TFlowBoxClass
  TFlowBoxClass* = object 
    parent_class*: TContainerClass
    child_activated*: proc (box: PFlowBox; child: PFlowBoxChild) {.
        cdecl.}
    selected_children_changed*: proc (box: PFlowBox) {.cdecl.}
    activate_cursor_child*: proc (box: PFlowBox) {.cdecl.}
    toggle_cursor_child*: proc (box: PFlowBox) {.cdecl.}
    move_cursor*: proc (box: PFlowBox; step: MovementStep; 
                        count: gint) {.cdecl.}
    select_all*: proc (box: PFlowBox) {.cdecl.}
    unselect_all*: proc (box: PFlowBox) {.cdecl.}
    ugtk_reserved1*: proc () {.cdecl.}
    ugtk_reserved2*: proc () {.cdecl.}
    ugtk_reserved3*: proc () {.cdecl.}
    ugtk_reserved4*: proc () {.cdecl.}
    ugtk_reserved5*: proc () {.cdecl.}
    ugtk_reserved6*: proc () {.cdecl.}

template TYPE_FLOW_BOX_CHILD*(): expr = 
  (gtk_flow_box_child_get_type())

template FLOW_BOX_CHILD_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_FLOW_BOX_CHILD, TFlowBoxChild))

template FLOW_BOX_CHILD_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_FLOW_BOX_CHILD, 
                           TFlowBoxChildClass))

template IS_FLOW_BOX_CHILD*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_FLOW_BOX_CHILD))

template IS_FLOW_BOX_CHILD_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_FLOW_BOX_CHILD))

template FLOW_BOX_CHILD_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), EG_TYPE_FLOW_BOX_CHILD, 
                             TFlowBoxChildClass))
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

sed  -i "s/family: PPangoFontFamily;/family: PFontFamily;/g" final.nim
sed  -i "s/face: PPangoFontFace;/face: pango.PFontFace;/g" final.nim
sed  -i "s/: PPangoFontFace {/: pango.PFontFace {/g" final.nim
sed  -i "s/: PPangoFontFamily {/: PFontFamily {/g" final.nim

i="\
template ICON_FACTORY_TEMPLATE*(object: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((object), TYPE_ICON_FACTORY, TIconFactory))

template ICON_FACTORY_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_ICON_FACTORY, TIconFactoryClass))

template IS_ICON_FACTORY*(object: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((object), TYPE_ICON_FACTORY))
"
j="\
template ICON_FACTORY_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_ICON_FACTORY, TIconFactory))

template ICON_FACTORY_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_ICON_FACTORY, TIconFactoryClass))

template IS_ICON_FACTORY*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_ICON_FACTORY))
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

sed  -i "s/parse_func: PStylePropertyParser;/parse_func: ptr StylePropertyParser;/g" final.nim

i="\
type 
  PStyleContext* = ptr TStyleContext
  TStyleContext* = object 
    parent_object*: TGObject
    priv*: PStyleContextPrivate

type 
  PStyleContextClass* = ptr TStyleContextClass
  TStyleContextClass* = object 
    parent_class*: TGObjectClass
    changed*: proc (context: PStyleContext) {.cdecl.}
    ugtk_reserved1*: proc () {.cdecl.}
    ugtk_reserved2*: proc () {.cdecl.}
    ugtk_reserved3*: proc () {.cdecl.}
    ugtk_reserved4*: proc () {.cdecl.}
"
j="\
type 
  PSettings* = ptr TSettings
  TSettings* = object 
    parent_instance*: TGObject
    priv*: PSettingsPrivate
"
perl -0777 -p -i -e "s/\Q$i\E//s" final.nim
perl -0777 -p -i -e "s/\Q$j\E/$j$i/s" final.nim

i="\
proc gtk_style_context_has_region*(context: PStyleContext; 
                                   region_name: CSTRING; 
                                   flags_return: PRegionFlags): gboolean {.
    cdecl, importc: \"gtk_style_context_has_region\", dynlib: lib.}
"
j="\
proc gtk_style_context_has_region*(context: PStyleContext; 
                                   region_name: CSTRING; 
                                   flags_return: var RegionFlags): gboolean {.
    cdecl, importc: \"gtk_style_context_has_region\", dynlib: lib.}
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim


i="\
proc gtk_theming_engine_has_region*(engine: PThemingEngine; 
                                    style_region: CSTRING; 
                                    flags: PRegionFlags): gboolean {.
    cdecl, importc: \"gtk_theming_engine_has_region\", dynlib: lib.}
"
j="\
proc gtk_theming_engine_has_region*(engine: PThemingEngine; 
                                    style_region: CSTRING; 
                                    flags: var RegionFlags): gboolean {.
    cdecl, importc: \"gtk_theming_engine_has_region\", dynlib: lib.}
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
proc gtk_widget_path_iter_has_region*(path: PWidgetPath; pos: gint; 
                                      name: CSTRING; 
                                      flags: PRegionFlags): gboolean {.
    cdecl, importc: \"gtk_widget_path_iter_has_region\", dynlib: lib.}
proc gtk_widget_path_iter_has_qregion*(path: PWidgetPath; pos: gint; 
    qname: TGQuark; flags: PRegionFlags): gboolean {.cdecl, 
    importc: \"gtk_widget_path_iter_has_qregion\", dynlib: lib.}
"
j="\
proc gtk_widget_path_iter_has_region*(path: PWidgetPath; pos: gint; 
                                      name: CSTRING; 
                                      flags: var RegionFlags): gboolean {.
    cdecl, importc: \"gtk_widget_path_iter_has_region\", dynlib: lib.}
proc gtk_widget_path_iter_has_qregion*(path: PWidgetPath; pos: gint; 
    qname: TGQuark; flags: var RegionFlags): gboolean {.cdecl, 
    importc: \"gtk_widget_path_iter_has_qregion\", dynlib: lib.}
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

sed  -i "s/direction: PangoDirection)/direction: pango.TDirection)/g" final.nim

sed  -i "s/: PPangoFontMap {/: pango.PFontMap {/g" final.nim
sed  -i "s/PPangoLogAttr/pango.PLogAttr/g" final.nim

i="\
proc gtk_icon_theme_get_search_path*(icon_theme: PIconTheme; 
                                     path: ptr Pptr gchar; 
                                     n_elements: Pgint) {.cdecl, 
    importc: \"gtk_icon_theme_get_search_path\", dynlib: lib.}
"
j="\
proc gtk_icon_theme_get_search_path*(icon_theme: PIconTheme; 
                                     path: var PPgchar; 
                                     n_elements: Pgint) {.cdecl, 
    importc: \"gtk_icon_theme_get_search_path\", dynlib: lib.}
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

sed  -i "s/pos: PIconViewDropPosition)/pos: var IconViewDropPosition)/g" final.nim

sed  -i "s/   object\*: TIMContext/   obj\*: TIMContext/g" final.nim

i="\
template TYPE_ICON_VIEW*(): expr = 
  (gtk_icon_view_get_type())

template ICON_VIEW_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_ICON_VIEW, TIconView))

template ICON_VIEW_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_ICON_VIEW, TIconViewClass))

template IS_ICON_VIEW*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_ICON_VIEW))

template IS_ICON_VIEW_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_ICON_VIEW))

template ICON_VIEW_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_ICON_VIEW, TIconViewClass))

type 
  IconViewForeachFunc* = proc (icon_view: PIconView; 
                                  path: PTreePath; data: gpointer) {.
      cdecl.}
type 
  IconViewDropPosition* {.size: sizeof(cint).} = enum 
    ICON_VIEW_NO_DROP, ICON_VIEW_DROP_INTO, ICON_VIEW_DROP_LEFT, 
    ICON_VIEW_DROP_RIGHT, ICON_VIEW_DROP_ABOVE, 
    ICON_VIEW_DROP_BELOW
type 
  PIconView* = ptr TIconView
  TIconView* = object 
    parent*: TContainer
    priv*: PIconViewPrivate

type 
  PIconViewClass* = ptr TIconViewClass
  TIconViewClass* = object 
    parent_class*: TContainerClass
    item_activated*: proc (icon_view: PIconView; path: PTreePath) {.
        cdecl.}
    selection_changed*: proc (icon_view: PIconView) {.cdecl.}
    select_all*: proc (icon_view: PIconView) {.cdecl.}
    unselect_all*: proc (icon_view: PIconView) {.cdecl.}
    select_cursor_item*: proc (icon_view: PIconView) {.cdecl.}
    toggle_cursor_item*: proc (icon_view: PIconView) {.cdecl.}
    move_cursor*: proc (icon_view: PIconView; step: MovementStep; 
                        count: gint): gboolean {.cdecl.}
    activate_cursor_item*: proc (icon_view: PIconView): gboolean {.cdecl.}
    ugtk_reserved1*: proc () {.cdecl.}
    ugtk_reserved2*: proc () {.cdecl.}
    ugtk_reserved3*: proc () {.cdecl.}
    ugtk_reserved4*: proc () {.cdecl.}
"
j="\
type 
  PIconView* = ptr TIconView
  TIconView* = object 
    parent*: TContainer
    priv*: PIconViewPrivate

type 
  PIconViewClass* = ptr TIconViewClass
  TIconViewClass* = object 
    parent_class*: TContainerClass
    item_activated*: proc (icon_view: PIconView; path: PTreePath) {.
        cdecl.}
    selection_changed*: proc (icon_view: PIconView) {.cdecl.}
    select_all*: proc (icon_view: PIconView) {.cdecl.}
    unselect_all*: proc (icon_view: PIconView) {.cdecl.}
    select_cursor_item*: proc (icon_view: PIconView) {.cdecl.}
    toggle_cursor_item*: proc (icon_view: PIconView) {.cdecl.}
    move_cursor*: proc (icon_view: PIconView; step: MovementStep; 
                        count: gint): gboolean {.cdecl.}
    activate_cursor_item*: proc (icon_view: PIconView): gboolean {.cdecl.}
    ugtk_reserved1*: proc () {.cdecl.}
    ugtk_reserved2*: proc () {.cdecl.}
    ugtk_reserved3*: proc () {.cdecl.}
    ugtk_reserved4*: proc () {.cdecl.}

template TYPE_ICON_VIEW*(): expr = 
  (gtk_icon_view_get_type())

template ICON_VIEW_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_ICON_VIEW, TIconView))

template ICON_VIEW_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_ICON_VIEW, TIconViewClass))

template IS_ICON_VIEW*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_ICON_VIEW))

template IS_ICON_VIEW_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_ICON_VIEW))

template ICON_VIEW_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_ICON_VIEW, TIconViewClass))

type 
  IconViewForeachFunc* = proc (icon_view: PIconView; 
                                  path: PTreePath; data: gpointer) {.
      cdecl.}
type 
  IconViewDropPosition* {.size: sizeof(cint).} = enum 
    ICON_VIEW_NO_DROP, ICON_VIEW_DROP_INTO, ICON_VIEW_DROP_LEFT, 
    ICON_VIEW_DROP_RIGHT, ICON_VIEW_DROP_ABOVE, 
    ICON_VIEW_DROP_BELOW
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PLinkButtonClass* = ptr TLinkButtonClass
  TLinkButtonClass* = object 
    parent_class*: TButtonClass
    activate_link*: proc (button: PLinkButton): gboolean {.cdecl.}
    _gtk_padding1*: proc () {.cdecl.}
    _gtk_padding2*: proc () {.cdecl.}
    _gtk_padding3*: proc () {.cdecl.}
    _gtk_padding4*: proc () {.cdecl.}
"
j="\
type 
  PLinkButtonClass* = ptr TLinkButtonClass
  TLinkButtonClass* = object 
    parent_class*: TButtonClass
    activate_link*: proc (button: PLinkButton): gboolean {.cdecl.}
    ugtk_padding1*: proc () {.cdecl.}
    ugtk_padding2*: proc () {.cdecl.}
    ugtk_padding3*: proc () {.cdecl.}
    ugtk_padding4*: proc () {.cdecl.}
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PListBoxRow* = ptr TListBoxRow
  TListBoxRow* = object 
    parent_instance*: TBin

type 
  PListBoxRowClass* = ptr TListBoxRowClass
  TListBoxRowClass* = object 
    parent_class*: TBinClass
    activate*: proc (row: PListBoxRow) {.cdecl.}
    ugtk_reserved1*: proc () {.cdecl.}
    ugtk_reserved2*: proc () {.cdecl.}
"
j="\
type 
  PListBox* = ptr TListBox
  TListBox* = object 
    parent_instance*: TContainer
"
perl -0777 -p -i -e "s/\Q$i\E//s" final.nim
perl -0777 -p -i -e "s/\Q$j\E/$j$i/s" final.nim

sed  -i "s/(argc: Pcint;/(argc: var cint;/g" final.nim
sed  -i "s/(argcp: Pcint; argvp: PcstringArray)/(argcp: var cint; argvp: var cstringArray)/g" final.nim

# init -- we use gtk2.nim poiter parameter for now, see bottom of this file
#sed  -i "s/; argv: PcstringArray/; argv: var cstringArray/g" final.nim

sed  -i "s/(argc: Pgint; argv: ptr Pptr gchar;/(argc: var gint; argv: var PPgchar;/g" final.nim

sed  -i "s/(argc: Pgint; argv: ptr Pptr gchar)/(argc: var gint; argv: var PPgchar)/g" final.nim

i="\
type 
  PPageRange* = ptr TPageRange
  TPageRange* = object 
    start*: gint
    end*: gint

"
j="\
type 
  PPageRange* = ptr TPageRange
  TPageRange* = object 
    start*: gint
    e*: gint

"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PRecentManagerClass* = ptr TRecentManagerClass
  TRecentManagerClass* = object 
    parent_class*: TGObjectClass
    changed*: proc (manager: PRecentManager) {.cdecl.}
    _gtk_recent1*: proc () {.cdecl.}
    _gtk_recent2*: proc () {.cdecl.}
    _gtk_recent3*: proc () {.cdecl.}
    _gtk_recent4*: proc () {.cdecl.}
"
j="\
type 
  PRecentManagerClass* = ptr TRecentManagerClass
  TRecentManagerClass* = object 
    parent_class*: TGObjectClass
    changed*: proc (manager: PRecentManager) {.cdecl.}
    ugtk_recent1*: proc () {.cdecl.}
    ugtk_recent2*: proc () {.cdecl.}
    ugtk_recent3*: proc () {.cdecl.}
    ugtk_recent4*: proc () {.cdecl.}
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

sed  -i "s/time_: Ptime_t)/time: Ptime_t)/g" final.nim

i="\
type 
  RecentFilterFunc* = proc (filter_info: PRecentFilterInfo; 
                               user_data: gpointer): gboolean {.cdecl.}
type 
  PRecentFilterInfo* = ptr TRecentFilterInfo
  TRecentFilterInfo* = object 
    contains*: RecentFilterFlags
    uri*: CSTRING
    display_name*: CSTRING
    mime_type*: CSTRING
    applications*: ptr CSTRING
    groups*: ptr CSTRING
    age*: gint
"
j="\
type 
  PRecentFilterInfo* = ptr TRecentFilterInfo
  TRecentFilterInfo* = object 
    contains*: RecentFilterFlags
    uri*: CSTRING
    display_name*: CSTRING
    mime_type*: CSTRING
    applications*: ptr CSTRING
    groups*: ptr CSTRING
    age*: gint
type 
  RecentFilterFunc* = proc (filter_info: PRecentFilterInfo; 
                               user_data: gpointer): gboolean {.cdecl.}
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

sed  -i "s/value\*: GValue/value\*: TGValue/g" final.nim

i="\
proc gtk_status_icon_get_geometry*(status_icon: PStatusIcon; 
                                   screen: ptr PScreen; 
                                   area: gdk2.PRectangle; 
                                   orientation: POrientation): gboolean {.
    cdecl, importc: \"gtk_status_icon_get_geometry\", dynlib: lib.}
"
j="\
proc gtk_status_icon_get_geometry*(status_icon: PStatusIcon; 
                                   screen: ptr PScreen; 
                                   area: gdk2.PRectangle; 
                                   orientation: var Orientation): gboolean {.
    cdecl, importc: \"gtk_status_icon_get_geometry\", dynlib: lib.}
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PSwitchClass* = ptr TSwitchClass
  TSwitchClass* = object 
    parent_class*: TWidgetClass
    activate*: proc (sw: PSwitch) {.cdecl.}
    _switch_padding_1*: proc () {.cdecl.}
    _switch_padding_2*: proc () {.cdecl.}
    _switch_padding_3*: proc () {.cdecl.}
    _switch_padding_4*: proc () {.cdecl.}
    _switch_padding_5*: proc () {.cdecl.}
    _switch_padding_6*: proc () {.cdecl.}
"
j="\
type 
  PSwitchClass* = ptr TSwitchClass
  TSwitchClass* = object 
    parent_class*: TWidgetClass
    activate*: proc (sw: PSwitch) {.cdecl.}
    uswitch_padding_1*: proc () {.cdecl.}
    uswitch_padding_2*: proc () {.cdecl.}
    uswitch_padding_3*: proc () {.cdecl.}
    uswitch_padding_4*: proc () {.cdecl.}
    uswitch_padding_5*: proc () {.cdecl.}
    uswitch_padding_6*: proc () {.cdecl.}
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
template TEXT_MARK_TEMPLATE*(object: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((object), TYPE_TEXT_MARK, TTextMark))

template TEXT_MARK_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_TEXT_MARK, TTextMarkClass))

template IS_TEXT_MARK*(object: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((object), TYPE_TEXT_MARK))
"
j="\
template TEXT_MARK_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_TEXT_MARK, TTextMark))

template TEXT_MARK_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_TEXT_MARK, TTextMarkClass))

template IS_TEXT_MARK*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_TEXT_MARK))
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  TextBufferTargetInfo* {.size: sizeof(cint).} = enum 
    TEXT_BUFFER_TARGET_INFO_BUFFER_CONTENTS = - 1, 
    TEXT_BUFFER_TARGET_INFO_RICH_TEXT = - 2, 
    TEXT_BUFFER_TARGET_INFO_TEXT = - 3
"
j="\
type 
  TextBufferTargetInfo* {.size: sizeof(cint).} = enum 
    TEXT_BUFFER_TARGET_INFO_TEXT = - 3
    TEXT_BUFFER_TARGET_INFO_RICH_TEXT = - 2, 
    TEXT_BUFFER_TARGET_INFO_BUFFER_CONTENTS = - 1, 
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
proc gtk_text_buffer_insert_range_interactive*(buffer: PTextBuffer; 
    iter: PTextIter; start: PTextIter; end: PTextIter; 
    default_editable: gboolean): gboolean {.cdecl, 
    importc: \"gtk_text_buffer_insert_range_interactive\", dynlib: lib.}
"
j="\
proc gtk_text_buffer_insert_range_interactive*(buffer: PTextBuffer; 
    iter: PTextIter; start: PTextIter; e: PTextIter; 
    default_editable: gboolean): gboolean {.cdecl, 
    importc: \"gtk_text_buffer_insert_range_interactive\", dynlib: lib.}
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
proc gtk_text_buffer_get_text*(buffer: PTextBuffer; 
                               start: PTextIter; end: PTextIter; 
                               include_hidden_chars: gboolean): CSTRING {.
    cdecl, importc: \"gtk_text_buffer_get_text\", dynlib: lib.}
"
j="\
proc gtk_text_buffer_get_text*(buffer: PTextBuffer; 
                               start: PTextIter; e: PTextIter; 
                               include_hidden_chars: gboolean): CSTRING {.
    cdecl, importc: \"gtk_text_buffer_get_text\", dynlib: lib.}
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
proc gtk_text_buffer_get_slice*(buffer: PTextBuffer; 
                                start: PTextIter; end: PTextIter; 
                                include_hidden_chars: gboolean): CSTRING {.
    cdecl, importc: \"gtk_text_buffer_get_slice\", dynlib: lib.}
"
j="\
proc gtk_text_buffer_get_slice*(buffer: PTextBuffer; 
                                start: PTextIter; e: PTextIter; 
                                include_hidden_chars: gboolean): CSTRING {.
    cdecl, importc: \"gtk_text_buffer_get_slice\", dynlib: lib.}
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  TextBufferSerializeFunc* = proc (register_buffer: PTextBuffer; 
                                      content_buffer: PTextBuffer; 
                                      start: PTextIter; 
                                      end: PTextIter; length: Pgsize; 
                                      user_data: gpointer): Pguint8 {.cdecl.}
"
j="\
type 
  TextBufferSerializeFunc* = proc (register_buffer: PTextBuffer; 
                                      content_buffer: PTextBuffer; 
                                      start: PTextIter; 
                                      e: PTextIter; length: Pgsize; 
                                      user_data: gpointer): Pguint8 {.cdecl.}
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
proc gtk_text_buffer_serialize*(register_buffer: PTextBuffer; 
                                content_buffer: PTextBuffer; 
                                format: TGdkAtom; start: PTextIter; 
                                end: PTextIter; length: Pgsize): Pguint8 {.
    cdecl, importc: \"gtk_text_buffer_serialize\", dynlib: lib.}
"
j="\
proc gtk_text_buffer_serialize*(register_buffer: PTextBuffer; 
                                content_buffer: PTextBuffer; 
                                format: TGdkAtom; start: PTextIter; 
                                e: PTextIter; length: Pgsize): Pguint8 {.
    cdecl, importc: \"gtk_text_buffer_serialize\", dynlib: lib.}
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
const 
  TEXT_VIEW_PRIORITY_VALIDATE* = (GDK_PRIORITY_REDRAW + 5)
"
j="\
const 
  TEXT_VIEW_PRIORITY_VALIDATE* = (gdk3.PRIORITY_REDRAW + 5)
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PAction* = ptr TAction
  TAction* = object 
    object*: TGObject
    private_data*: PActionPrivate
"
j="\
type 
  PAction* = ptr TAction
  TAction* = object 
    obj*: TGObject
    private_data*: PActionPrivate
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  ColorSelectionChangePaletteFunc* = proc (colors: PColor; 
      n_colors: gint) {.cdecl.}
type 
  ColorSelectionChangePaletteWithScreenFunc* = proc (screen: PGdkScreen; 
      colors: PColor; n_colors: gint) {.cdecl.}
"
j="\
type 
  ColorSelectionChangePaletteFunc* = proc (colors: gdk2.PColor; 
      n_colors: gint) {.cdecl.}
type 
  ColorSelectionChangePaletteWithScreenFunc* = proc (screen: PGdkScreen; 
      colors: gdk3.PColor; n_colors: gint) {.cdecl.}
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
proc gtk_color_selection_palette_from_string*(str: CSTRING; 
    colors: ptr PColor; n_colors: Pgint): gboolean {.cdecl, 
    importc: \"gtk_color_selection_palette_from_string\", dynlib: lib.}
proc gtk_color_selection_palette_to_string*(colors: PColor; 
    n_colors: gint): CSTRING {.cdecl, importc: \"gtk_color_selection_palette_to_string\", 
                                 dynlib: lib.}
"
j="\
proc gtk_color_selection_palette_from_string*(str: CSTRING; 
    colors: var gdk2.PColor; n_colors: Pgint): gboolean {.cdecl, 
    importc: \"gtk_color_selection_palette_from_string\", dynlib: lib.}
proc gtk_color_selection_palette_to_string*(colors: gdk2.PColor; 
    n_colors: gint): CSTRING {.cdecl, importc: \"gtk_color_selection_palette_to_string\", 
                                 dynlib: lib.}
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

sed  -i "s/resolved_gradient: ptr Pcairo_pattern_t)/resolved_gradient: var Ppattern)/g" final.nim
sed  -i "s/context: PStyleContext): Pcairo_pattern_t {/context: PStyleContext): Ppattern {/g" final.nim

i="\
template RC_STYLE_TEMPLATE*(object: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((object), TYPE_RC_STYLE, TRcStyle))
"
j="\
template RC_STYLE_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_RC_STYLE, TRcStyle))
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
template IS_RC_STYLE*(object: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((object), TYPE_RC_STYLE))
"
j="\
template IS_RC_STYLE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_RC_STYLE))
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
    color_flags*: array[5, RcFlags]
    fg*: array[5, Color]
    bg*: array[5, Color]
    text*: array[5, Color]
    base*: array[5, Color]
"
j="\
    color_flags*: array[5, RcFlags]
    fg*: array[5, gdk2.TColor]
    bg*: array[5, gdk2.TColor]
    text*: array[5, gdk2.TColor]
    base*: array[5, gdk2.TColor]
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
template STYLE_TEMPLATE*(object: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((object), TYPE_STYLE, TStyle))
"
j="\
template STYLE_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_STYLE, TStyle))
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
template IS_STYLE*(object: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((object), TYPE_STYLE))
"
j="\
template IS_STYLE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_STYLE))
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

sed  -i "s/detail: CSTRING; y1_: gint; y2_: gint; x: gint)/detail: CSTRING; y1: gint; y2: gint; x: gint)/g" final.nim

sed  -i "s/(a: PColor; b: PColor; k: gdouble)/(a: gdk2.PColor; b: gdk2.PColor; k: gdouble)/g" final.nim

sed  -i "s/(widget: PWidget; primary: PColor;/(widget: PWidget; primary: gdk2.PColor;/g" final.nim

sed  -i "s/PAtkRelationSet/PRelationSet/g" final.nim
sed  -i "s/AtkCoordType/TCoordType/g" final.nim

i="\
when defined(ENABLE_NLS): 
  template P_*(String: expr): expr = 
    g_dgettext(GETTEXT_PACKAGE, \"-properties\", String)

else: 
  template P_*(String: expr): expr = 
    (String)

template I_*(string: expr): expr = 
  g_intern_static_string(string)
"
j="\
when defined(ENABLE_NLS): 
  template P_UNDERSCORE*(String: expr): expr = 
    g_dgettext(GETTEXT_PACKAGE, \"-properties\", String)

else: 
  template P_UNDERSCORE*(String: expr): expr = 
    (String)

template I_UNDERSCORE*(string: expr): expr = 
  g_intern_static_string(string)
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

sed  -i "s/ gdk2\./ gdk3\./g" final.nim

i="\
type 
  Orientation* {.size: sizeof(cint).} = enum 
    ORIENTATION_HORIZONTAL, ORIENTATION_VERTICAL
"
j="\
type
  POrientation* = ptr Orientation
  Orientation* {.size: sizeof(cint).} = enum 
    ORIENTATION_HORIZONTAL, ORIENTATION_VERTICAL
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PStyle* = ptr TStyle
  TStyle* = object 
    parent_instance*: TGObject
    fg*: array[5, Color]
    bg*: array[5, Color]
    light*: array[5, Color]
    dark*: array[5, Color]
    mid*: array[5, Color]
    text*: array[5, Color]
    base*: array[5, Color]
    text_aa*: array[5, Color]
    black*: gdk3.TColor
    white*: gdk3.TColor
    font_desc*: PPangoFontDescription
    xthickness*: gint
    ythickness*: gint
    background*: array[5, ptr cairo_pattern_t]
    attach_count*: gint
    visual*: PGdkVisual
    private_font_desc*: PPangoFontDescription
    rc_style*: PRcStyle
    styles*: PGSList
    property_cache*: PGArray
    icon_factories*: PGSList
"
j="\
type 
  PStyle* = ptr TStyle
  TStyle* = object 
    parent_instance*: TGObject
    fg*: array[5, gdk3.TColor]
    bg*: array[5, gdk3.TColor]
    light*: array[5, gdk3.TColor]
    dark*: array[5, gdk3.TColor]
    mid*: array[5, gdk3.TColor]
    text*: array[5, gdk3.TColor]
    base*: array[5, gdk3.TColor]
    text_aa*: array[5, gdk3.TColor]
    black*: gdk3.TColor
    white*: gdk3.TColor
    font_desc*: PPangoFontDescription
    xthickness*: gint
    ythickness*: gint
    background*: array[5, ptr Ppattern]
    attach_count*: gint
    visual*: PGdkVisual
    private_font_desc*: PPangoFontDescription
    rc_style*: PRcStyle
    styles*: PGSList
    property_cache*: PGArray
    icon_factories*: PGSList
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

ruby ../fixTenum.rb final.nim
ruby ../fixTfunc.rb final.nim

i="\
proc gtk_scrolled_window_get_policy*(scrolled_window: PScrolledWindow; 
                                     hscrollbar_policy: PPolicyType; 
                                     vscrollbar_policy: PPolicyType) {.
    cdecl, importc: \"gtk_scrolled_window_get_policy\", dynlib: lib.}
"
j="\
proc gtk_scrolled_window_get_policy*(scrolled_window: PScrolledWindow; 
                                     hscrollbar_policy: var TPolicyType; 
                                     vscrollbar_policy: var TPolicyType) {.
    cdecl, importc: \"gtk_scrolled_window_get_policy\", dynlib: lib.}
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
proc gtk_rc_parse_priority*(scanner: PGScanner; 
                            priority: PPathPriorityType): guint {.cdecl, 
    importc: \"gtk_rc_parse_priority\", dynlib: lib.}
"
j="\
proc gtk_rc_parse_priority*(scanner: PGScanner; 
                            priority: var TPathPriorityType): guint {.cdecl, 
    importc: \"gtk_rc_parse_priority\", dynlib: lib.}
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

ruby ../fix_object_of.rb final.nim

i="\
type 
  PContainer* = ptr TContainer
  TContainer* = object 
    widget*: TWidget
    priv*: PContainerPrivate
"
j="\
type 
  PContainer* = ptr TContainer
  TContainer* = object of TWidget
    priv*: PContainerPrivate
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PBin* = ptr TBin
  TBin* = object 
    container*: TContainer
    priv*: PBinPrivate
"
j="\
type 
  PBin* = ptr TBin
  TBin* = object of TContainer
    priv*: PBinPrivate
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PWindow* = ptr TWindow
  TWindow* = object 
    bin*: TBin
    priv*: PWindowPrivate
"
j="\
type 
  PWindow* = ptr TWindow
  TWindow* = object of TBin
    priv*: PWindowPrivate
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PDialog* = ptr TDialog
  TDialog* = object 
    window*: TWindow
    priv*: PDialogPrivate
"
j="\
type 
  PDialog* = ptr TDialog
  TDialog* = object of TWindow
    priv*: PDialogPrivate
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PMisc* = ptr TMisc
  TMisc* = object 
    widget*: TWidget
    priv*: PMiscPrivate
"
j="\
type 
  PMisc* = ptr TMisc
  TMisc* = object of TWidget
    priv*: PMiscPrivate
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PMenuShell* = ptr TMenuShell
  TMenuShell* = object 
    container*: TContainer
    priv*: PMenuShellPrivate
"
j="\
type 
  PMenuShell* = ptr TMenuShell
  TMenuShell* = object of  TContainer
    priv*: PMenuShellPrivate
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PMenu* = ptr TMenu
  TMenu* = object 
    menu_shell*: TMenuShell
    priv*: PMenuPrivate
"
j="\
type 
  PMenu* = ptr TMenu
  TMenu* = object of TMenuShell
    priv*: PMenuPrivate
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PLabel* = ptr TLabel
  TLabel* = object 
    misc*: TMisc
    priv*: PLabelPrivate
"
j="\
type 
  PLabel* = ptr TLabel
  TLabel* = object of TMisc
    priv*: PLabelPrivate
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PAccelLabel* = ptr TAccelLabel
  TAccelLabel* = object 
    label*: TLabel
    priv*: PAccelLabelPrivate
"
j="\
type 
  PAccelLabel* = ptr TAccelLabel
  TAccelLabel* = object of TLabel
    priv*: PAccelLabelPrivate
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PActionableInterface* = ptr TActionableInterface
  TActionableInterface* = object 
    g_iface*: TGTypeInterface
"
j="\
type 
  PActionableInterface* = ptr TActionableInterface
  TActionableInterface* = object of TGTypeInterface
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PActionBar* = ptr TActionBar
  TActionBar* = object 
    bin*: TBin
"
j="\
type 
  PActionBar* = ptr TActionBar
  TActionBar* = object of TBin
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PAlignment* = ptr TAlignment
  TAlignment* = object 
    bin*: TBin
    priv*: PAlignmentPrivate
"
j="\
type 
  PAlignment* = ptr TAlignment
  TAlignment* = object of TBin
    priv*: PAlignmentPrivate
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PBox* = ptr TBox
  TBox* = object 
    container*: TContainer
    priv*: PBoxPrivate
"
j="\
type 
  PBox* = ptr TBox
  TBox* = object of TContainer
    priv*: PBoxPrivate
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PTreeModelIface* = ptr TTreeModelIface
  TTreeModelIface* = object 
    g_iface*: TGTypeInterface
"
j="\
type 
  PTreeModelIface* = ptr TTreeModelIface
  TTreeModelIface* = object of TGTypeInterface
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PCellEditableIface* = ptr TCellEditableIface
  TCellEditableIface* = object 
    g_iface*: TGTypeInterface
"
j="\
type 
  PCellEditableIface* = ptr TCellEditableIface
  TCellEditableIface* = object of TGTypeInterface
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PTreeSortableIface* = ptr TTreeSortableIface
  TTreeSortableIface* = object 
    g_iface*: TGTypeInterface
"
j="\
type 
  PTreeSortableIface* = ptr TTreeSortableIface
  TTreeSortableIface* = object of TGTypeInterface
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PEditableInterface* = ptr TEditableInterface
  TEditableInterface* = object 
    base_iface*: TGTypeInterface
"
j="\
type 
  PEditableInterface* = ptr TEditableInterface
  TEditableInterface* = object of TGTypeInterface
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PImage* = ptr TImage
  TImage* = object 
    misc*: TMisc
    priv*: PImagePrivate
"
j="\
type 
  PImage* = ptr TImage
  TImage* = object of TMisc
    priv*: PImagePrivate
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PArrow* = ptr TArrow
  TArrow* = object 
    misc*: TMisc
    priv*: PArrowPrivate
"
j="\
type 
  PArrow* = ptr TArrow
  TArrow* = object of TMisc
    priv*: PArrowPrivate
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PFrame* = ptr TFrame
  TFrame* = object 
    bin*: TBin
    priv*: PFramePrivate
"
j="\
type 
  PFrame* = ptr TFrame
  TFrame* = object of TBin
    priv*: PFramePrivate
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PAspectFrame* = ptr TAspectFrame
  TAspectFrame* = object 
    frame*: TFrame
    priv*: PAspectFramePrivate
"
j="\
type 
  PAspectFrame* = ptr TAspectFrame
  TAspectFrame* = object of TFrame 
    priv*: PAspectFramePrivate
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PButtonBox* = ptr TButtonBox
  TButtonBox* = object 
    box*: TBox
    priv*: PButtonBoxPrivate
"
j="\
type 
  PButtonBox* = ptr TButtonBox
  TButtonBox* = object of TBox 
    priv*: PButtonBoxPrivate
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PBuildableIface* = ptr TBuildableIface
  TBuildableIface* = object 
    g_iface*: TGTypeInterface
"
j="\
type 
  PBuildableIface* = ptr TBuildableIface
  TBuildableIface* = object of TGTypeInterface
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PButton* = ptr TButton
  TButton* = object 
    bin*: TBin
    priv*: PButtonPrivate
"
j="\
type 
  PButton* = ptr TButton
  TButton* = object of TBin
    priv*: PButtonPrivate
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PCalendar* = ptr TCalendar
  TCalendar* = object 
    widget*: TWidget
    priv*: PCalendarPrivate
"
j="\
type 
  PCalendar* = ptr TCalendar
  TCalendar* = object of TWidget
    priv*: PCalendarPrivate
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PCellLayoutIface* = ptr TCellLayoutIface
  TCellLayoutIface* = object 
    g_iface*: TGTypeInterface
"
j="\
type 
  PCellLayoutIface* = ptr TCellLayoutIface
  TCellLayoutIface* = object of TGTypeInterface
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PCellRendererComboClass* = ptr TCellRendererComboClass
  TCellRendererComboClass* = object 
    parent*: TCellRendererTextClass
"
j="\
type 
  PCellRendererComboClass* = ptr TCellRendererComboClass
  TCellRendererComboClass* = object of TCellRendererTextClass
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PCellRendererSpinClass* = ptr TCellRendererSpinClass
  TCellRendererSpinClass* = object 
    parent*: TCellRendererTextClass
"
j="\
type 
  PCellRendererSpinClass* = ptr TCellRendererSpinClass
  TCellRendererSpinClass* = object of TCellRendererTextClass
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PToggleButton* = ptr TToggleButton
  TToggleButton* = object 
    button*: TButton
    priv*: PToggleButtonPrivate
"
j="\
type 
  PToggleButton* = ptr TToggleButton
  TToggleButton* = object of TButton
    priv*: PToggleButtonPrivate
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PCheckButton* = ptr TCheckButton
  TCheckButton* = object 
    toggle_button*: TToggleButton
"
j="\
type 
  PCheckButton* = ptr TCheckButton
  TCheckButton* = object of TToggleButton
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PMenuItem* = ptr TMenuItem
  TMenuItem* = object 
    bin*: TBin
    priv*: PMenuItemPrivate
"
j="\
type 
  PMenuItem* = ptr TMenuItem
  TMenuItem* = object of TBin
    priv*: PMenuItemPrivate
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PCheckMenuItem* = ptr TCheckMenuItem
  TCheckMenuItem* = object 
    menu_item*: TMenuItem
    priv*: PCheckMenuItemPrivate
"
j="\
type 
  PCheckMenuItem* = ptr TCheckMenuItem
  TCheckMenuItem* = object of TMenuItem
    priv*: PCheckMenuItemPrivate
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PColorButton* = ptr TColorButton
  TColorButton* = object 
    button*: TButton
    priv*: PColorButtonPrivate
"
j="\
type 
  PColorButton* = ptr TColorButton
  TColorButton* = object of TButton
    priv*: PColorButtonPrivate
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PColorChooserInterface* = ptr TColorChooserInterface
  TColorChooserInterface* = object 
    base_interface*: TGTypeInterface
"
j="\
type 
  PColorChooserInterface* = ptr TColorChooserInterface
  TColorChooserInterface* = object of TGTypeInterface
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PDrawingArea* = ptr TDrawingArea
  TDrawingArea* = object 
    widget*: TWidget
    dummy*: gpointer
"
j="\
type 
  PDrawingArea* = ptr TDrawingArea
  TDrawingArea* = object of TWidget
    dummy*: gpointer
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PEventBox* = ptr TEventBox
  TEventBox* = object 
    bin*: TBin
    priv*: PEventBoxPrivate
"
j="\
type 
  PEventBox* = ptr TEventBox
  TEventBox* = object of TBin
    priv*: PEventBoxPrivate
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PExpander* = ptr TExpander
  TExpander* = object 
    bin*: TBin
    priv*: PExpanderPrivate
"
j="\
type 
  PExpander* = ptr TExpander
  TExpander* = object of TBin
    priv*: PExpanderPrivate
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PFixed* = ptr TFixed
  TFixed* = object 
    container*: TContainer
    priv*: PFixedPrivate
"
j="\
type 
  PFixed* = ptr TFixed
  TFixed* = object of TContainer
    priv*: PFixedPrivate
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PFixedChild* = ptr TFixedChild
  TFixedChild* = object 
    widget*: PWidget
    x*: gint
    y*: gint
"
j="\
type 
  PFixedChild* = ptr TFixedChild
  TFixedChild* = object of PWidget
    x*: gint
    y*: gint
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PFlowBox* = ptr TFlowBox
  TFlowBox* = object 
    container*: TContainer
"
j="\
type 
  PFlowBox* = ptr TFlowBox
  TFlowBox* = object of TContainer
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PFontButton* = ptr TFontButton
  TFontButton* = object 
    button*: TButton
    priv*: PFontButtonPrivate
"
j="\
type 
  PFontButton* = ptr TFontButton
  TFontButton* = object of TButton
    priv*: PFontButtonPrivate
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PFontChooserIface* = ptr TFontChooserIface
  TFontChooserIface* = object 
    base_iface*: TGTypeInterface
"
j="\
type 
  PFontChooserIface* = ptr TFontChooserIface
  TFontChooserIface* = object of TGTypeInterface
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PGrid* = ptr TGrid
  TGrid* = object 
    container*: TContainer
    priv*: PGridPrivate
"
j="\
type 
  PGrid* = ptr TGrid
  TGrid* = object of TContainer
    priv*: PGridPrivate
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PHeaderBar* = ptr THeaderBar
  THeaderBar* = object 
    container*: TContainer
"
j="\
type 
  PHeaderBar* = ptr THeaderBar
  THeaderBar* = object of TContainer
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PStyleProviderIface* = ptr TStyleProviderIface
  TStyleProviderIface* = object 
    g_iface*: TGTypeInterface
"
j="\
type 
  PStyleProviderIface* = ptr TStyleProviderIface
  TStyleProviderIface* = object of TGTypeInterface
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PIMContextSimple* = ptr TIMContextSimple
  TIMContextSimple* = object 
    obj*: TIMContext
    priv*: PIMContextSimplePrivate
"
j="\
type 
  PIMContextSimple* = ptr TIMContextSimple
  TIMContextSimple* = object of TIMContext
    priv*: PIMContextSimplePrivate
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PIMMulticontext* = ptr TIMMulticontext
  TIMMulticontext* = object 
    obj*: TIMContext
    priv*: PIMMulticontextPrivate
"
j="\
type 
  PIMMulticontext* = ptr TIMMulticontext
  TIMMulticontext* = object of TIMContext
    priv*: PIMMulticontextPrivate
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PInvisible* = ptr TInvisible
  TInvisible* = object 
    widget*: TWidget
    priv*: PInvisiblePrivate
"
j="\
type 
  PInvisible* = ptr TInvisible
  TInvisible* = object of TWidget
    priv*: PInvisiblePrivate
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PLayout* = ptr TLayout
  TLayout* = object 
    container*: TContainer
    priv*: PLayoutPrivate
"
j="\
type 
  PLayout* = ptr TLayout
  TLayout* = object of TContainer
    priv*: PLayoutPrivate
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PMenuBar* = ptr TMenuBar
  TMenuBar* = object 
    menu_shell*: TMenuShell
    priv*: PMenuBarPrivate
"
j="\
type 
  PMenuBar* = ptr TMenuBar
  TMenuBar* = object of TMenuShell
    priv*: PMenuBarPrivate
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PMountOperation* = ptr TMountOperation
  TMountOperation* = object 
    parent_instance*: GMountOperation
    priv*: PMountOperationPrivate
"
j="\
type 
  PMountOperation* = ptr TMountOperation
  TMountOperation* = object of GMountOperation
    priv*: PMountOperationPrivate
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PMountOperationClass* = ptr TMountOperationClass
  TMountOperationClass* = object 
    parent_class*: GMountOperationClass
"
j="\
type 
  PMountOperationClass* = ptr TMountOperationClass
  TMountOperationClass* = object of GMountOperationClass
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PNotebook* = ptr TNotebook
  TNotebook* = object 
    container*: TContainer
    priv*: PNotebookPrivate
"
j="\
type 
  PNotebook* = ptr TNotebook
  TNotebook* = object of TContainer
    priv*: PNotebookPrivate
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PNumerableIcon* = ptr TNumerableIcon
  TNumerableIcon* = object 
    parent*: GEmblemedIcon
    priv*: PNumerableIconPrivate
"
j="\
type 
  PNumerableIcon* = ptr TNumerableIcon
  TNumerableIcon* = object of GEmblemedIcon
    priv*: PNumerableIconPrivate
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PNumerableIconClass* = ptr TNumerableIconClass
  TNumerableIconClass* = object 
    parent_class*: GEmblemedIconClass
"
j="\
type 
  PNumerableIconClass* = ptr TNumerableIconClass
  TNumerableIconClass* = object of GEmblemedIconClass
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  POrientableIface* = ptr TOrientableIface
  TOrientableIface* = object 
    base_iface*: TGTypeInterface
"
j="\
type 
  POrientableIface* = ptr TOrientableIface
  TOrientableIface* = object of TGTypeInterface
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PPaned* = ptr TPaned
  TPaned* = object 
    container*: TContainer
    priv*: PPanedPrivate
"
j="\
type 
  PPaned* = ptr TPaned
  TPaned* = object of TContainer
    priv*: PPanedPrivate
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PPrintOperationPreviewIface* = ptr TPrintOperationPreviewIface
  TPrintOperationPreviewIface* = object 
    g_iface*: TGTypeInterface
"
j="\
type 
  PPrintOperationPreviewIface* = ptr TPrintOperationPreviewIface
  TPrintOperationPreviewIface* = object of TGTypeInterface
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PRadioButton* = ptr TRadioButton
  TRadioButton* = object 
    check_button*: TCheckButton
    priv*: PRadioButtonPrivate
"
j="\
type 
  PRadioButton* = ptr TRadioButton
  TRadioButton* = object of TCheckButton
    priv*: PRadioButtonPrivate
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PRadioButton* = ptr TRadioButton
  TRadioButton* = object 
    check_button*: TCheckButton
    priv*: PRadioButtonPrivate
"
j="\
type 
  PRadioButton* = ptr TRadioButton
  TRadioButton* = object of TCheckButton
    priv*: PRadioButtonPrivate
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PRadioMenuItem* = ptr TRadioMenuItem
  TRadioMenuItem* = object 
    check_menu_item*: TCheckMenuItem
    priv*: PRadioMenuItemPrivate
"
j="\
type 
  PRadioMenuItem* = ptr TRadioMenuItem
  TRadioMenuItem* = object of TCheckMenuItem
    priv*: PRadioMenuItemPrivate
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PRange* = ptr TRange
  TRange* = object 
    widget*: TWidget
    priv*: PRangePrivate
"
j="\
type 
  PRange* = ptr TRange
  TRange* = object of TWidget
    priv*: PRangePrivate
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PRecentChooserIface* = ptr TRecentChooserIface
  TRecentChooserIface* = object 
    base_iface*: TGTypeInterface
"
j="\
type 
  PRecentChooserIface* = ptr TRecentChooserIface
  TRecentChooserIface* = object of TGTypeInterface
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PScale* = ptr TScale
  TScale* = object 
    range*: TRange
    priv*: PScalePrivate
"
j="\
type 
  PScale* = ptr TScale
  TScale* = object of TRange
    priv*: PScalePrivate
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PScrollableInterface* = ptr TScrollableInterface
  TScrollableInterface* = object 
    base_iface*: TGTypeInterface
"
j="\
type 
  PScrollableInterface* = ptr TScrollableInterface
  TScrollableInterface* = object of TGTypeInterface
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PScrollbar* = ptr TScrollbar
  TScrollbar* = object 
    range*: TRange
"
j="\
type 
  PScrollbar* = ptr TScrollbar
  TScrollbar* = object of TRange
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PScrolledWindow* = ptr TScrolledWindow
  TScrolledWindow* = object 
    container*: TBin
    priv*: PScrolledWindowPrivate
"
j="\
type 
  PScrolledWindow* = ptr TScrolledWindow
  TScrolledWindow* = object of TBin
    priv*: PScrolledWindowPrivate
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PSeparator* = ptr TSeparator
  TSeparator* = object 
    widget*: TWidget
    priv*: PSeparatorPrivate
"
j="\
type 
  PSeparator* = ptr TSeparator
  TSeparator* = object of TWidget
    priv*: PSeparatorPrivate
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PSeparatorMenuItem* = ptr TSeparatorMenuItem
  TSeparatorMenuItem* = object 
    menu_item*: TMenuItem
"
j="\
type 
  PSeparatorMenuItem* = ptr TSeparatorMenuItem
  TSeparatorMenuItem* = object of TMenuItem
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PSpinButton* = ptr TSpinButton
  TSpinButton* = object 
    entry*: TEntry
    priv*: PSpinButtonPrivate
"
j="\
type 
  PSpinButton* = ptr TSpinButton
  TSpinButton* = object of TEntry
    priv*: PSpinButtonPrivate
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PStackSwitcher* = ptr TStackSwitcher
  TStackSwitcher* = object 
    widget*: TBox
"
j="\
type 
  PStackSwitcher* = ptr TStackSwitcher
  TStackSwitcher* = object of TBox
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PStatusbar* = ptr TStatusbar
  TStatusbar* = object 
    parent_widget*: TBox
    priv*: PStatusbarPrivate
"
j="\
type 
  PStatusbar* = ptr TStatusbar
  TStatusbar* = object of TBox
    priv*: PStatusbarPrivate
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PToolbar* = ptr TToolbar
  TToolbar* = object 
    container*: TContainer
    priv*: PToolbarPrivate
"
j="\
type 
  PToolbar* = ptr TToolbar
  TToolbar* = object of TContainer
    priv*: PToolbarPrivate
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PToolShellIface* = ptr TToolShellIface
  TToolShellIface* = object 
    g_iface*: TGTypeInterface
"
j="\
type 
  PToolShellIface* = ptr TToolShellIface
  TToolShellIface* = object of TGTypeInterface
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PTreeDragSourceIface* = ptr TTreeDragSourceIface
  TTreeDragSourceIface* = object 
    g_iface*: TGTypeInterface
"
j="\
type 
  PTreeDragSourceIface* = ptr TTreeDragSourceIface
  TTreeDragSourceIface* = object of TGTypeInterface
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PTreeDragDestIface* = ptr TTreeDragDestIface
  TTreeDragDestIface* = object 
    g_iface*: TGTypeInterface
"
j="\
type 
  PTreeDragDestIface* = ptr TTreeDragDestIface
  TTreeDragDestIface* = object of TGTypeInterface
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PViewport* = ptr TViewport
  TViewport* = object 
    bin*: TBin
    priv*: PViewportPrivate
"
j="\
type 
  PViewport* = ptr TViewport
  TViewport* = object of TBin
    priv*: PViewportPrivate
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PAction* = ptr TAction
  TAction* = object 
    obj*: TGObject
    private_data*: PActionPrivate
"
j="\
type 
  PAction* = ptr TAction
  TAction* = object of TGObject
    private_data*: PActionPrivate
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PActivatableIface* = ptr TActivatableIface
  TActivatableIface* = object 
    g_iface*: TGTypeInterface
"
j="\
type 
  PActivatableIface* = ptr TActivatableIface
  TActivatableIface* = object of TGTypeInterface
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PHandleBox* = ptr THandleBox
  THandleBox* = object 
    bin*: TBin
    priv*: PHandleBoxPrivate
"
j="\
type 
  PHandleBox* = ptr THandleBox
  THandleBox* = object of TBin
    priv*: PHandleBoxPrivate
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PHButtonBox* = ptr THButtonBox
  THButtonBox* = object 
    button_box*: TButtonBox
"
j="\
type 
  PHButtonBox* = ptr THButtonBox
  THButtonBox* = object of TButtonBox
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PHBox* = ptr THBox
  THBox* = object 
    box*: TBox
"
j="\
type 
  PHBox* = ptr THBox
  THBox* = object of TBox
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PHPaned* = ptr THPaned
  THPaned* = object 
    paned*: TPaned
"
j="\
type 
  PHPaned* = ptr THPaned
  THPaned* = object of TPaned
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PHScale* = ptr THScale
  THScale* = object 
    scale*: TScale
"
j="\
type 
  PHScale* = ptr THScale
  THScale* = object of TScale
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PHScrollbar* = ptr THScrollbar
  THScrollbar* = object 
    scrollbar*: TScrollbar
"
j="\
type 
  PHScrollbar* = ptr THScrollbar
  THScrollbar* = object of TScrollbar
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PHSeparator* = ptr THSeparator
  THSeparator* = object 
    separator*: TSeparator
"
j="\
type 
  PHSeparator* = ptr THSeparator
  THSeparator* = object of TSeparator
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PImageMenuItem* = ptr TImageMenuItem
  TImageMenuItem* = object 
    menu_item*: TMenuItem
    priv*: PImageMenuItemPrivate
"
j="\
type 
  PImageMenuItem* = ptr TImageMenuItem
  TImageMenuItem* = object of TMenuItem
    priv*: PImageMenuItemPrivate
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PTable* = ptr TTable
  TTable* = object 
    container*: TContainer
    priv*: PTablePrivate
"
j="\
type 
  PTable* = ptr TTable
  TTable* = object of TContainer
    priv*: PTablePrivate
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PTableChild* = ptr TTableChild
  TTableChild* = object 
    widget*: PWidget
"
j="\
type 
  PTableChild* = ptr TTableChild
  TTableChild* = object of PWidget
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PTearoffMenuItem* = ptr TTearoffMenuItem
  TTearoffMenuItem* = object 
    menu_item*: TMenuItem
    priv*: PTearoffMenuItemPrivate
"
j="\
type 
  PTearoffMenuItem* = ptr TTearoffMenuItem
  TTearoffMenuItem* = object of TMenuItem
    priv*: PTearoffMenuItemPrivate
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PVButtonBox* = ptr TVButtonBox
  TVButtonBox* = object 
    button_box*: TButtonBox
"
j="\
type 
  PVButtonBox* = ptr TVButtonBox
  TVButtonBox* = object of TButtonBox
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PVBox* = ptr TVBox
  TVBox* = object 
    box*: TBox
"
j="\
type 
  PVBox* = ptr TVBox
  TVBox* = object of TBox
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PVPaned* = ptr TVPaned
  TVPaned* = object 
    paned*: TPaned
"
j="\
type 
  PVPaned* = ptr TVPaned
  TVPaned* = object of TPaned
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PVScale* = ptr TVScale
  TVScale* = object 
    scale*: TScale
"
j="\
type 
  PVScale* = ptr TVScale
  TVScale* = object of TScale
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PVScrollbar* = ptr TVScrollbar
  TVScrollbar* = object 
    scrollbar*: TScrollbar
"
j="\
type 
  PVScrollbar* = ptr TVScrollbar
  TVScrollbar* = object of TScrollbar
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PVSeparator* = ptr TVSeparator
  TVSeparator* = object 
    separator*: TSeparator
"
j="\
type 
  PVSeparator* = ptr TVSeparator
  TVSeparator* = object of TSeparator
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PScrollbar* = ptr TScrollbar
  TScrollbar* = object 
    range*: TRange
"
j="\
type 
  PScrollbar* = ptr TScrollbar
  TScrollbar* = object of TRange
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

# renumber private_data
i="\
type 
  PToggleAction* = ptr TToggleAction
  TToggleAction* = object of TAction
    private_data*: PToggleActionPrivate
"
j="\
type 
  PToggleAction* = ptr TToggleAction
  TToggleAction* = object of TAction
    private_data2*: PToggleActionPrivate
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  PAction* = ptr TAction
  TAction* = object of TGObject
    private_data*: PActionPrivate
"
j="\
type 
  PAction* = ptr TAction
  TAction* = object of TGObject
    private_data1*: PActionPrivate
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

ruby ../fix_reserved.rb final.nim
#exit
ruby ../fix_new.rb final.nim
ruby ../fix_proc_gtk.rb final.nim 'gtk_'

sed -i "s/\* = object $/\*{\.final, pure\.} = object /g" final.nim

sed -i "s/\(^\s*proc \)ref\(\*(\w\)/\1re\2/g" final.nim
sed -i "s/\(^\s*proc \)gtk_/\1/g" final.nim

# name conflict -- add gtk prefix again
i="\
proc stock_add*(items: PStockItem; n_items: guint) {.cdecl, 
    importc: \"gtk_stock_add\", dynlib: lib.}
"
j="\
proc gtk_stock_add*(items: PStockItem; n_items: guint) {.cdecl, 
    importc: \"gtk_stock_add\", dynlib: lib.}
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

sed -i "s/ TAtkRole/ TRole/g" final.nim
sed -i "s/ TAtkObject/ atk.TObject/g" final.nim
sed -i "s/ PAtkObject/ atk.PObject/g" final.nim
sed -i "s/ AtkTextBoundary/ atk.TTextBoundary/g" final.nim
sed -i "s/PAtkAttributeSet/atk.PAttributeSet/g" final.nim

sed -i "s/: GdkWindowTypeHint/: TGdkWindowTypeHint/g" final.nim
sed -i "s/ PPangoFontDescription/ PFontDescription/g" final.nim

# plain pointers from gtk2.nim
sed -i "s/(argc: var cint; argv: PcstringArray)/(argc: pointer; argv: pointer)/g" final.nim

# from gtk2
i='
proc init_gtk() =
  var
    cmdLine{.importc: "cmdLine".}: array[0..255, cstring]
    cmdCount{.importc: "cmdCount".}: cint
  init(addr(cmdLine), addr(cmdCount))
'
echo "$i" >> final.nim

sed -i "s/ GMountOperation/ TGMountOperation/g" final.nim
sed -i "s/ GMountOperationClass/ TGMountOperationClass/g" final.nim
sed -i "s/ GEmblemedIconClass/ TGEmblemedIconClass/g" final.nim
sed -i "s/ GEmblemedIcon/ TGEmblemedIcon/g" final.nim

sed -i "s/\( priv[0-9]\?[0-9]\?[0-9]\?\)\*: /\1: /g" final.nim
sed -i "s/\(reserved[0-9]\?[0-9]\?[0-9]\?\)\*: /\1: /g" final.nim

# this is more a proof of concept for bitfield access, we do not really need bitfields in GTK3 any more...
###echo "# bitfield access" >> final.nim
###ruby ../bitfield.rb PTextAppearance bitfield0_TextAppearance underline 3 0 >> final.nim
###ruby ../bitfield.rb PTextAppearance bitfield0_TextAppearance strikethrough 4 4 >> final.nim

# some templates
i="\
template TYPE_RADIO_MENU_ITEM*(): expr = 
  (gtk_radio_menu_item_get_type())
"
j="\
template radio_button_new*(): expr =
  new_from_widget(cast[PRadioButton](0))
template radio_button_new_with_label*(label: CSTRING): expr =
  new_with_label_from_widget(cast[PRadioButton](0), label)
template radio_button_new_with_mnemonic*(label: CSTRING): expr =
  new_with_mnemonic_from_widget(cast[PRadioButton](0), label)
template radio_button_new*(w: PRadioButton): expr =
  new_from_widget(w)
template radio_button_new_with_label*(w: PRadioButton; label: CSTRING): expr =
  new_with_label_from_widget(w, label)
template radio_button_new_with_mnemonic*(w: PRadioButton; label: CSTRING): expr =
  new_with_mnemonic_from_widget(w, label)
"
perl -0777 -p -i -e "s/\Q$i\E/$j$i/s" final.nim

i="\
proc window_new*(typ: TWindowType): PWindow {.cdecl, 
    importc: \"gtk_window_new\", dynlib: lib.}
"
j="\
proc window_new*(typ: TWindowType = TWindowType.TOPLEVEL): PWindow {.cdecl, 
    importc: \"gtk_window_new\", dynlib: lib.}
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

sed -i "s/ va_list\* = PGObject/ Pva_list\* = PGObject/g" final.nim
sed -i "s/: va_list)/: Pva_list)/g" final.nim

# allow w.color= for set_color(w, and w.color for get_color(w,
# name conflict only occurs without use of fix_enum_prefix.rb
#sed -i "s/proc get_expand\*(/wxyz get_expand\*(/g" final.nim
#sed -i "s/proc get_stock\*(/wxyz get_stock\*(/g" final.nim
#sed -i "s/proc get_object\*(/wxyz get_object\*(/g" final.nim
perl -0777 -p -i -e "s/(\nproc set_)(\w\w*)(\*\(.*?})/\1\2\3\nproc \`\2=\`\3/sg" final.nim
perl -0777 -p -i -e "s/(\nproc get_)(\w\w*)(\*\(.*?})/\1\2\3\nproc \2\3/sg" final.nim
#sed -i "s/wxyz get_expand\*(/proc get_expand\*(/g" final.nim
#sed -i "s/wxyz get_stock\*(/proc get_stock\*(/g" final.nim
#sed -i "s/wxyz get_object\*(/proc get_object\*(/g" final.nim

ruby ../fix_enum_prefix.rb final.nim
sed -i "s/  UNIT_PIXEL\* = UNIT_NONE/  UNIT_PIXEL\* = TUNIT.NONE/" final.nim
sed -i "s/Stock/Stck/g" final.nim
sed -i "s/proc object\*(builder: PBuilder; name: CSTRING): PGObject/proc obj\*(builder: PBuilder; name: CSTRING): PGObject/" final.nim

echo 'init_gtk()' >> final.nim

mv final.nim gtk3.nim

exit

