#!/bin/bash
# S. Salewski, 26-MAY-2014
# Generate GTK3 bindings for Nimrod -- this is for GDK headers 3.12.1
# we try to process all headers, including win32, wayland, quartz, broadway
# currently I can test only with x11
#
gtk3_dir="/home/stefan/Downloads/gtk+-3.12.1" # have currently only 3.10.8 lib installed!
final="final.h" # the input file for c2nim
list="list.txt"
wdir="tmp_gdk"

targets='x11 win32 wayland quartz broadway' # I can test only x11 currently!
all_t=". ${targets}"

rm -rf $wdir # start from scratch
mkdir $wdir
cd $wdir
cp -r $gtk3_dir/gdk .
cd gdk

# I think for 3.12 we have all -- for newer headers we may investigate the generated list
#echo 'we may miss these headers -- please check:'
#for i in $all_t ; do
#  grep -c DECL ${i}/*.h | grep h:0
#done

# we insert in each header a marker with the filename
# may fail if G_BEGIN_DECLS macro is missing in a header
for j in $all_t ; do
  for i in ${j}/*.h; do
    sed -i "/^G_BEGIN_DECLS/a${i}_ssalewski;" $i
  done
done

# order matters.
cat gdk.h x11/gdkx.h win32/gdkwin32.h wayland/gdkwayland.h quartz/gdkquartz.h broadway/gdkbroadway.h > all.h

cd ..

touch windows.h # empty dummy headers to make cpp happy
touch commctrl.h
touch wayland-client.h
mkdir AppKit
touch AppKit/AppKit.h

# cpp run with all headers to determine order
echo "cat \\" > $list
echo 'gdkkeysyms.h \' >> $list # we need this also
echo 'gdkintl.h \' >> $list

cpp -I. `pkg-config --cflags gtk+-3.0` gdk/all.h $final
rm windows.h  commctrl.h wayland-client.h 
rm -r AppKit

# extract file names and push names to list
grep ssalewski $final | sed 's/_ssalewski;/ \\/' >> $list

# add remaining missing headers
# for now we put all at the bottom and do manually ordering if necessary
echo 'broadway/broadway-buffer.h \' >> $list
echo 'broadway/broadway-protocol.h \' >> $list
echo 'broadway/broadway-output.h \' >> $list
echo 'broadway/broadway-server.h \' >> $list # will fail for GDK_ prefix removal!
echo 'broadway/gdkbroadway-server.h \' >> $list

i=`uniq -d $list | wc -l`
if [ $i != 0 ]; then echo 'list contains duplicates!'; exit; fi;

# now we work again with original headers
rm -rf gdk
cp -r $gtk3_dir/gdk . 

sed -i "s/#define GDK_PRIORITY_EVENTS (G_PRIORITY_DEFAULT)//" gdk/gdkmain.h # redefinition

# insert for each header file its name as first line
for j in $all_t ; do
  for i in gdk/${j}/*.h; do
    sed -i "1i/* file: $i */" $i
  done
done
cd gdk
bash ../$list > ../$final
cd ..
rm $list

# insert empty dummy #def statements for strange macros
# we restrict use of wildcards in sed/perl patterns to limit risc of damage something!
for i in 2 4 6 8 10 12 ; do
  sed -i "1i#def GDK_AVAILABLE_IN_3_$i\n#def GDK_DEPRECATED_IN_3_$i\n#def GDK_DEPRECATED_IN_3_${i}_FOR(x)" $final
done

sed -i "1i#def G_BEGIN_DECLS" $final
sed -i "1i#def G_END_DECLS" $final

sed -i 's/^G_BEGIN_DECLS//' $final # there was a problem with c2nim with two macros following each other, so we remove a few
sed -i 's/^G_GNUC_WARN_UNUSED_RESULT //' $final
sed -i "1i#def GDK_AVAILABLE_IN_ALL" $final
sed -i "1i#def GDK_DEPRECATED_IN_3_0" $final
sed -i "1i#def GDK_DEPRECATED_IN_3_0_FOR(x)" $final
sed -i "1i#def G_GNUC_CONST" $final
sed -i "1i#def GDK_THREADS_DEPRECATED" $final
sed -i "1i#def G_GNUC_WARN_UNUSED_RESULT" $final
sed -i "1i#def G_GNUC_NULL_TERMINATED" $final

sed -i 's/#define \(\w\w*\)\( \s*(\w\w* \?())\)/#define \1() \2/' $final # insert () after name, so it is a template, not a const
sed -i 's/#define GDK_NONE            _GDK_MAKE_ATOM (0)/#define GDK_NONE()            _GDK_MAKE_ATOM (0)/' $final
sed -i 's/#define GDK_SELECTION_PRIMARY 		_GDK_MAKE_ATOM (1)/#define GDK_SELECTION_PRIMARY() 		_GDK_MAKE_ATOM (1)/' $final
sed -i 's/#define GDK_SELECTION_SECONDARY 	_GDK_MAKE_ATOM (2)/#define GDK_SELECTION_SECONDARY() 	_GDK_MAKE_ATOM (2)/' $final
sed -i 's/#define GDK_SELECTION_CLIPBOARD 	_GDK_MAKE_ATOM (69)/#define GDK_SELECTION_CLIPBOARD() 	_GDK_MAKE_ATOM (69)/' $final
sed -i 's/#define GDK_TARGET_BITMAP 		_GDK_MAKE_ATOM (5)/#define GDK_TARGET_BITMAP() 		_GDK_MAKE_ATOM (5)/' $final
sed -i 's/#define GDK_TARGET_COLORMAP 		_GDK_MAKE_ATOM (7)/#define GDK_TARGET_COLORMAP() 		_GDK_MAKE_ATOM (7)/' $final
sed -i 's/#define GDK_TARGET_DRAWABLE 		_GDK_MAKE_ATOM (17)/#define GDK_TARGET_DRAWABLE() 		_GDK_MAKE_ATOM (17)/' $final
sed -i 's/#define GDK_TARGET_PIXMAP 		_GDK_MAKE_ATOM (20)/#define GDK_TARGET_PIXMAP() 		_GDK_MAKE_ATOM (20)/' $final
sed -i 's/#define GDK_TARGET_STRING 		_GDK_MAKE_ATOM (31)/#define GDK_TARGET_STRING() 		_GDK_MAKE_ATOM (31)/' $final
sed -i 's/#define GDK_SELECTION_TYPE_ATOM 	_GDK_MAKE_ATOM (4)/#define GDK_SELECTION_TYPE_ATOM() 	_GDK_MAKE_ATOM (4)/' $final
sed -i 's/#define GDK_SELECTION_TYPE_BITMAP 	_GDK_MAKE_ATOM (5)/#define GDK_SELECTION_TYPE_BITMAP() 	_GDK_MAKE_ATOM (5)/' $final
sed -i 's/#define GDK_SELECTION_TYPE_COLORMAP 	_GDK_MAKE_ATOM (7)/#define GDK_SELECTION_TYPE_COLORMAP() 	_GDK_MAKE_ATOM (7)/' $final
sed -i 's/#define GDK_SELECTION_TYPE_DRAWABLE 	_GDK_MAKE_ATOM (17)/#define GDK_SELECTION_TYPE_DRAWABLE() 	_GDK_MAKE_ATOM (17)/' $final
sed -i 's/#define GDK_SELECTION_TYPE_INTEGER 	_GDK_MAKE_ATOM (19)/#define GDK_SELECTION_TYPE_INTEGER() 	_GDK_MAKE_ATOM (19)/' $final
sed -i 's/#define GDK_SELECTION_TYPE_PIXMAP 	_GDK_MAKE_ATOM (20)/#define GDK_SELECTION_TYPE_PIXMAP() 	_GDK_MAKE_ATOM (20)/' $final
sed -i 's/#define GDK_SELECTION_TYPE_WINDOW 	_GDK_MAKE_ATOM (33)/#define GDK_SELECTION_TYPE_WINDOW() 	_GDK_MAKE_ATOM (33)/' $final
sed -i 's/#define GDK_SELECTION_TYPE_STRING 	_GDK_MAKE_ATOM (31)/#define GDK_SELECTION_TYPE_STRING() 	_GDK_MAKE_ATOM (31)/' $final

# we use perl for multiline text replacement -- generally $i is replaced by $j
# we use large blocks even for small fixes, so we can better verify substitution and prevent
# unwanted replacements
i="\
struct _GdkEventKey
{
  GdkEventType type;
  GdkWindow *window;
  gint8 send_event;
  guint32 time;
  guint state;
  guint keyval;
  gint length;
  gchar *string;
  guint16 hardware_keycode;
  guint8 group;
  guint is_modifier : 1;
};
"
j="\
struct _GdkEventKey
{
  GdkEventType type;
  GdkWindow *window;
  gint8 send_event;
  guint32 time;
  guint state;
  guint keyval;
  gint length;
  gchar *string;
  guint16 hardware_keycode;
  guint8 group;
  guint is_modifier;
};
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" $final

perl -0777 -p -i -e 's/#if !?defined.*?error.*?#endif//sg' $final

# make targets optional: first file named $i generates #endif #ifdef pair 
for i in $targets ; do
  perl -0777 -p -i -e "s/\n.*?file: gdk\/${i}\/.*?\n/\n#enxdif\n#ifdef ${i}\n/" $final
done
perl -0777 -p -i -e "s/\n#enxdif\n/\n/" $final # first was wrong
sed -i 's/enxdif/endif/' $final
echo '#endif' >> $final

# GDK private/opaque data types
sed -i "/#define __GDK_DEVICE_H__/astruct _GdkDevice {};" $final
sed -i "/#define __GDK_DEVICE_H__/astruct _GdkWindow {};" $final
sed -i "/#define __GDK_DEVICE_H__/astruct _GdkScreen {};" $final
sed -i "/#define __GDK_DEVICE_H__/astruct _GdkDisplay {};" $final
sed -i "/#define __GDK_DEVICE_H__/astruct _GdkVisual {};" $final
sed -i "/#define __GDK_DEVICE_H__/astruct _GdkCursor {};" $final
sed -i "/#define __GDK_DEVICE_H__/astruct _GdkDragContext {};" $final
sed -i "/#define __GDK_DEVICE_H__/astruct _GdkAppLaunchContext {};" $final
sed -i "/#define __GDK_DEVICE_H__/astruct _GdkEventSequence {};" $final
sed -i "/#define __GDK_DEVICE_H__/astruct _GdkDeviceManager {};" $final
sed -i "/#define __GDK_DEVICE_H__/astruct _GdkDisplayManager {};" $final
sed -i "/#define __GDK_DEVICE_H__/astruct _GdkDisplayManagerClass {};" $final
sed -i "/#define __GDK_DEVICE_H__/astruct _GdkFrameTimings {};" $final
sed -i "/#define __GDK_DEVICE_H__/astruct _GdkFrameClock {};" $final
sed -i "/#define __GDK_DEVICE_H__/astruct _GdkKeymap {};" $final
sed -i "/#define __GDK_DEVICE_H__/astruct GOptionGroup {};" $final
sed -i "/#define __GDK_DEVICE_H__/astruct GOutputStream {};" $final
sed -i "/#define __GDK_DEVICE_H__/astruct _BroadwayBuffer {};" $final
sed -i "/#define __GDK_DEVICE_H__/astruct _GdkBroadwayServer {};" $final
sed -i "/#define __GDK_DEVICE_H__/astruct _BroadwayServer {};" $final
sed -i "/#define __GDK_DEVICE_H__/astruct BroadwayOutput {};" $final

# these are GObjects, we fix this later
fix2objof="GdkScreen GdkWindow GdkDisplay GdkVisual GdkCursor DragContext AppLaunchContext DeviceManager FrameClock Keymap GOutputStream"

# GdkDisplayManagerClass is GObjectClass

# this should be part of cairo module
sed -i "/#define __GDK_DEVICE_H__/astruct _cairo_t {};" $final
sed -i "/#define __GDK_DEVICE_H__/astruct _cairo_region_t {};" $final

sed  -i "s/(object)/(obj)/g" $final # name is used in macros, but object is keyword

ruby ../fix_.rb $final

# header for nimrod module
i='
#ifdef __INCREASE_TMP_INDENT__
#ifdef C2NIM
#  dynlib lib
#  cdecl
#  if defined(win32)
#    define lib "libgdk-win32-3.0-0.dll"
#  elif defined(macosx)
#    define lib "libgdk-quartz-3.0.dylib"
#  else
#    define lib "libgdk-3.so(|.0)"
#  endif
#endif
'

# this is missing from current cairo
j='
struct cairo_rectangle_int_t
{
  int x, y;
  int width, height;
};
'

echo "$i" > tmp1.txt
echo "$j" >> tmp1.txt

# glib GError, with GQuark replaced by TGQuark
j='
struct GError {
  TGQuark      domain;
  gint         code;
  gchar       *message;
};
'
echo "$j" >> tmp1.txt

i='
typedef PGObject PGIcon;
'
echo "$i" >> tmp1.txt

# opaque private types, direct child of GObject
# empty struct gives an empty object from c2nim, which we
# patch to object of TGObject later
# These obhects have no Gdk prefix!
opt='Display Window Visual Cursor Screen'
for i in $opt ; do
  echo "struct ${i} {};" >> tmp1.txt
done

# the xAtom defined in /usr/include/X11/X.h -- should be 32 bit
# we use gulong instead of unsigned long
j='
typedef gulong Atom;
'
echo "$j" >> tmp1.txt

# XID, also from /usr/include/X11/X.h
j='
typedef gulong XID;
'
echo "$j" >> tmp1.txt

# VisualID, also from /usr/include/X11/X.h
j='
typedef unsigned long VisualID;
'
echo "$j" >> tmp1.txt

# types of mswindows handle
j='
typedef unsigned long *HWND;
'
echo "$j" >> tmp1.txt

j='
typedef unsigned long *HGDIOBJ;
'
echo "$j" >> tmp1.txt

# Wayland data types (pointers, so we add the leading P here)
j='
typedef unsigned long *Pwl_seat;
'
echo "$j" >> tmp1.txt

j='
typedef unsigned long *Pwl_pointer;
'
echo "$j" >> tmp1.txt

j='
typedef unsigned long *Pwl_keyboard;
'
echo "$j" >> tmp1.txt

j='
typedef unsigned long *Pwl_display;
'
echo "$j" >> tmp1.txt

j='
typedef unsigned long *Pwl_compositor;
'
echo "$j" >> tmp1.txt

j='
typedef unsigned long *Pwl_surface;
'
echo "$j" >> tmp1.txt

j='
typedef unsigned long *Pxdg_shell;
'
echo "$j" >> tmp1.txt

# quartz pointers, also with P prefix
j='
typedef unsigned long *PNSString;
'
echo "$j" >> tmp1.txt

j='
typedef unsigned long *PNSImage;
'
echo "$j" >> tmp1.txt

j='
typedef unsigned long *PNSEvent;
'
echo "$j" >> tmp1.txt

j='
typedef unsigned long *PNSWindow;
'
echo "$j" >> tmp1.txt

j='
typedef unsigned long *PNSView;
'
echo "$j" >> tmp1.txt

#return type of gdk_quartz_drag_context_get_dragging_info_libgtk_only
j='
typedef unsigned long id;
'
echo "$j" >> tmp1.txt

echo "#endif\n" >> tmp1.txt # #ifdef __INCREASE_TMP_INDENT__

cat tmp1.txt $final > tmp2.txt
mv tmp2.txt $final
rm tmp1.txt

perl -0777 -p -i -e 's/\n#ifdef GDK_COMPILATION\n#else\n(.*?;\n)#endif\n/\1/sg' $final

c2nim --skipcomments --skipinclude $final

ruby ../remdef.rb final.nim

sed -i '1d' final.nim
sed -i 's/^  //' final.nim

sed -i "s/GDK_BROADWAY/GXDXKX_BROADWAY/g" final.nim
ruby ../mangler.rb final.nim GDK_
sed  -i "s/GXDXKX_BROADWAY/GDK_BROADWAY/g" final.nim

for i in Visual Window Atom Display Cursor Screen Broadway; do
  sed -i "s/Gdk$i/XGXdXk$i/g" final.nim
done
ruby ../mangler.rb final.nim Gdk

for i in Visual Window Atom Display Cursor Screen Broadway; do
  sed -i "s/XGXdXk$i/Gdk$i/g" final.nim
done

sed -i "2iimport" final.nim
sed -i "3i\  glib2, gdk2pixbuf, pango, cairo" final.nim

sed  -i "s/: ptr /: P/g" final.nim
sed  -i "s/: Pptr /: ptr P/g" final.nim

sed  -i "s/events: ptr Pptr TimeCoord;/events: ptr ptr PTimeCoord;/" final.nim # maybe var parameter?

ruby ../gen_ptr.rb final.nim
ruby ../fixT.rb final.nim
ruby ../fixTenum.rb final.nim
ruby ../fixTfunc.rb final.nim

# Fix this:
# KEY_a* =
# KEY_A* =
# But first fix triples
# KEY_ETH* =
# KEY_Eth* =
# KEY_eth* =
# KEY_THORN* =
# KEY_Thorn* =
# KEY_thorn* =
# KEY_CH* =
# KEY_C_H* =
# KEY_Ch* =
# KEY_C_h* =
# KEY_ch* =
# KEY_c_h* =

sed  -i "s/  KEY_Eth\* =/  KEY_CAP_Eth\* =/" final.nim
sed  -i "s/  KEY_ETH\* =/  KEY_CAPITAL_ETH\* =/" final.nim
sed  -i "s/  KEY_Thorn\* =/  KEY_CAP_Thorn\* =/" final.nim
sed  -i "s/  KEY_THORN\* =/  KEY_CAPITAL_THORN\* =/" final.nim
sed  -i "s/  KEY_CH\* =/  KEY_CAPITAL_C_CAPITAL_H\* =/" final.nim
sed  -i "s/  KEY_Ch\* =/  KEY_CAPITAL_C_h\* =/" final.nim
sed  -i "s/  KEY_C_H\* =/  KEY_CAPITAL_C_UNDERSCORE_CAPITAL_H\* =/" final.nim
sed  -i "s/  KEY_C_h\* =/  KEY_CAPITAL_C_UNDERSCORE_h\* =/" final.nim
sed  -i "s/  KEY_c_h\* =/  KEY_c_UNDERSCORE_h\* =/" final.nim

grep '^  KEY' final.nim | sed 's/\* =.*/\* =/g' | sort -r > temp0.txt

uniq -d -i temp0.txt > temp1.txt

sed -i 's/^/grep -i -o -m 1 "/' temp1.txt

sed -i 's/\* =$/\\* =" temp0.txt >> temp2.txt/' temp1.txt

bash temp1.txt

sed -i 's/  KEY_\(.*\)\* =/s%  KEY_\1\\\* =%  KEY_CAPITAL_\1\\\* =%/' temp2.txt

sed -i -f temp2.txt final.nim

rm temp?.txt

i=' MAKE_ATOM'
grep "${i}" final.nim
rc=$?
if [[ $rc == 0 ]] ; then
	echo "error, ${i} already exist!"
  exit
fi
sed  -i "s/ _MAKE_ATOM/ MAKE_ATOM/g" final.nim

i="\
  const 
    __GDKQUARTZ_H_INSIDE__* = true
"
perl -0777 -p -i -e "s/\Q$i\E//s" final.nim

i="\
type 
  Event* = _Event
"
perl -0777 -p -i -e "s/\Q$i\E//s" final.nim
sed  -i "s/  _Event\* = object  {.union.}/  Event\* = object  {.union.}/" final.nim

i="\
template POINTER_TO_ATOM*(ptr: expr): expr = 
  ((GdkAtom)(ptr))
"
j="\
template POINTER_TO_ATOM*(val: expr): expr = 
  (cast[GdkAtom](val))
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
  TStatus* {.size: sizeof(cint).} = enum 
    OK = 0, ERROR = - 1, ERROR_PARAM = - 2, ERROR_FILE = - 3, 
    ERROR_MEM = - 4
"
j="\
  TStatus* {.size: sizeof(cint).} = enum 
    ERROR_MEM = - 4, ERROR_FILE = - 3, ERROR_PARAM = - 2, ERROR = - 1, OK = 0
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

# Caution: we drop DOUBLE_BUTTON_PRESS and TRIPLE_BUTTON_PRESS -- we may ad named constants again
i="\
    DOUBLE_BUTTON_PRESS = 2BUTTON_PRESS, 3BUTTON_PRESS = 6, 
    TRIPLE_BUTTON_PRESS = 3BUTTON_PRESS, BUTTON_RELEASE = 7, 
"
j="\
    3BUTTON_PRESS = 6, 
    BUTTON_RELEASE = 7, 
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

# reordering...
i="\
type 
  TEventFunc* = proc (event: PEvent; data: gpointer) {.cdecl.}
"
j="\
proc gdk_event_get_type*(): GType {.cdecl, importc: \"gdk_event_get_type\", 
                                    dynlib: lib.}
"
perl -0777 -p -i -e "s/\Q$i\E//s" final.nim
perl -0777 -p -i -e "s/\Q$j\E/$i$j/s" final.nim

i="\
type 
  TFilterFunc* = proc (xevent: PXEvent; event: PEvent; 
                         data: gpointer): TFilterReturn {.cdecl.}
"
perl -0777 -p -i -e "s/\Q$i\E//s" final.nim
perl -0777 -p -i -e "s/\Q$j\E/$i$j/s" final.nim

perl -0777 -p -i -e "s/(\n.*?\(.*?)_:/\1:/sg" final.nim

sed  -i "s/_gdk_reserved/gdk_reserved/g" final.nim
sed  -i "s/  proc _gdk_atom_name_const/  proc gdk_atom_name_const/g" final.nim
sed  -i "s/ type\*: / typ\*: /g" final.nim

sed  -i "s/  XEvent\* = nil/  PXEvent\* = ptr TXEvent\\n  TXEvent\* = proc () {.cdecl.}/" final.nim # copied from GTK2

sed  -i "s/Pgchar/CSTRING/g" final.nim
sed  -i "s/2BUTTON_PRESS/BUTTON2_PRESS/g" final.nim
sed  -i "s/3BUTTON_PRESS/BUTTON3_PRESS/g" final.nim
sed  -i "s/template P_\*(String: expr)/template P_UNDERSCORE\*(String: expr)/g" final.nim
sed  -i "s/GdkAtom\* = ptr _GdkAtom/GdkAtom\* = ptr object/g" final.nim # is this rigth?
sed  -i "s/    in\*: gint16/    inner\*: gint16/g" final.nim

sed  -i "s/\(  TModifierType\* {\.size: sizeof(cint)\.} = enum \)/  PModifierType\* = ptr TModifierType \n\1/" final.nim
sed  -i "s/\(  TScrollDirection\* {\.size: sizeof(cint)\.} = enum \)/  PScrollDirection\* = ptr TScrollDirection \n\1/" final.nim

sed  -i "s/proc gdk_event_new\*(type: TEventType): PEvent {.cdecl, /proc gdk_event_new\*(typ: TEventType): PEvent {.cdecl, /g" final.nim

sed  -i "s/  \(Event\* = object  {.union.}\)/  PEvent\* = ptr TEvent\n  T\1/" final.nim

sed  -i "s/GDestroyNotify/TGDestroyNotify/" final.nim
sed  -i "s/Pcairo_font_options_t/PFontOptions/" final.nim
sed  -i "s/Pcairo_surface_t/PSurface/" final.nim
sed  -i "s/type: TDeviceType): PGList/typ: TDeviceType): PGList/" final.nim

sed  -i "s/\([ \[]\)GdkAtom/\1TGdkAtom/g" final.nim
sed  -i "s/\([ \[]\)Rectangle/\1TRectangle/" final.nim
sed  -i "s/PangoDirection/TDirection/" final.nim
sed  -i "s/PPangoContext/PContext/" final.nim
sed  -i "s/PangoContext/TContext/" final.nim

sed  -i "/    BLANK_CURSOR = - 2, CURSOR_IS_PIXMAP = - 1/d" final.nim
sed  -i "/  TGdkCursorType\* {.size: sizeof(cint).} = enum /a\    BLANK_CURSOR = - 2, CURSOR_IS_PIXMAP = - 1," final.nim

sed  -i "s/argv: ptr Pptr gchar/v: var PPgchar/" final.nim

sed  -i "s/    list: ptr Pptr gchar): gint {.cdecl, importc: "gdk_text_property_to_utf8_list_for_display",/    t: var PPgchar): gint {.cdecl, importc: "gdk_text_property_to_utf8_list_for_display",/" final.nim


sed  -i "s/proc gdk_pango_context_get_for_screen\*(screen: PGdkScreen): PContext/proc gdk_pango_context_get_for_screen\*(screen: PGdkScreen): Pango.PContext/" final.nim

sed  -i "s/proc gdk_pango_context_get\*(): PContext/proc gdk_pango_context_get\*(): Pango.PContext/" final.nim

sed  -i "s/PPangoLayoutLine/PLayoutLine/" final.nim
sed  -i "s/PPangoLayout/PLayout/" final.nim
sed  -i "s/    parent_class\*: GObjectClass/    parent_class\*: TGObjectClass/" final.nim
sed  -i "s/Pcairo_pattern_t/PPattern/" final.nim
sed  -i "s/cairo_content_t/TContent/" final.nim

sed  -i "s/cairo_format_t/TFormat/" final.nim

sed  -i "s/type: TGdkAtom;/typ: TGdkAtom;/g" final.nim

sed  -i "s/list: ptr Pptr gchar/t: var PPgchar/g" final.nim

perl -0777 -p -i -e "s/type \n(  TGdkAtom\* = ptr object)/type \n  PGdkAtom\* = ptr TGdkAtom\n\1/" final.nim
perl -0777 -p -i -e "s/type \n(  TRectangle\* = Tcairo_rectangle_int_t)/type \n  PRectangle\* = ptr TRectangle\n\1/" final.nim

i="\
type 
  TWMDecoration\* {\.size: sizeof\(cint\)\.} = enum 
"
j="\
type 
  PWMDecoration\* = ptr TWMDecoration
  TWMDecoration\* {\.size: sizeof\(cint\)\.} = enum 
"
perl -0777 -p -i -e "s/$i/$j/s" final.nim

i="\
type 
  TGdkVisualType\* {\.size: sizeof\(cint\)\.} = enum 
"
j="\
type 
  PGdkVisualType\* = ptr TGdkVisualType
  TGdkVisualType\* {\.size: sizeof\(cint\)\.} = enum
"
perl -0777 -p -i -e "s/$i/$j/s" final.nim

sed  -i "s/: GdkVisualType/: TGdkVisualType/" final.nim

i="\
proc gdk_window_set_decorations\*(window: PGdkWindow; 
                                 decorations: WMDecoration)
"
j="\
proc gdk_window_set_decorations\*(window: PGdkWindow; 
                                 decorations: TWMDecoration)
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

sed  -i "s/decorations: WMDecoration/decorations: TWMDecoration/" final.nim

i="\
  when defined(COMPILATION): 
  else: 
"
j="\
  when not(defined(COMPILATION)): 
"
perl -0777 -p -i -e "s/\Q$i\E/$j/sg" final.nim

sed  -i "s/(type: PNSString)/(typ: PNSString)/" final.nim

sed  -i "s/__BROADWAY_BUFFER__/UNDERSCORE_BROADWAY_BUFFER_UNDERSCORE/" final.nim

sed  -i "s/__BROADWAY_SERVER__/UNDERSCORE_BROADWAY_SERVER_UNDERSCORE/" final.nim

sed  -i "s/__GDK_BROADWAY_SERVER__/UNDERSCORE_GDK_BROADWAY_SERVER_UNDERSCORE/" final.nim

sed  -i "s/proc _gdk_broadway_server_/proc underscore_gdk_broadway_server_/" final.nim

sed  -i "s/      time_\*: guint32/      time_underscore\*: guint32/" final.nim
sed  -i "s/proc broadway_output_new\*(out: PGOutputStream/proc broadway_output_new\*(output: PGOutputStream/" final.nim

i="\
    TBroadwayEventType* {.size: sizeof(cint).} = enum 
      BROADWAY_EVENT_ENTER = 'e', BROADWAY_EVENT_LEAVE = 'l', 
      BROADWAY_EVENT_POINTER_MOVE = 'm', BROADWAY_EVENT_BUTTON_PRESS = 'b', 
      BROADWAY_EVENT_BUTTON_RELEASE = 'B', BROADWAY_EVENT_TOUCH = 't', 
      BROADWAY_EVENT_SCROLL = 's', BROADWAY_EVENT_KEY_PRESS = 'k', 
      BROADWAY_EVENT_KEY_RELEASE = 'K', BROADWAY_EVENT_GRAB_NOTIFY = 'g', 
      BROADWAY_EVENT_UNGRAB_NOTIFY = 'u', 
      BROADWAY_EVENT_CONFIGURE_NOTIFY = 'w', 
      BROADWAY_EVENT_DELETE_NOTIFY = 'W', 
      BROADWAY_EVENT_SCREEN_SIZE_CHANGED = 'd', BROADWAY_EVENT_FOCUS = 'f'
    TBroadwayOpType* {.size: sizeof(cint).} = enum 
      BROADWAY_OP_GRAB_POINTER = 'g', BROADWAY_OP_UNGRAB_POINTER = 'u', 
      BROADWAY_OP_NEW_SURFACE = 's', BROADWAY_OP_SHOW_SURFACE = 'S', 
      BROADWAY_OP_HIDE_SURFACE = 'H', BROADWAY_OP_RAISE_SURFACE = 'r', 
      BROADWAY_OP_LOWER_SURFACE = 'R', BROADWAY_OP_DESTROY_SURFACE = 'd', 
      BROADWAY_OP_MOVE_RESIZE = 'm', BROADWAY_OP_SET_TRANSIENT_FOR = 'p', 
      BROADWAY_OP_PUT_RGB = 'i', BROADWAY_OP_REQUEST_AUTH = 'l', 
      BROADWAY_OP_AUTH_OK = 'L', BROADWAY_OP_DISCONNECTED = 'D', 
      BROADWAY_OP_PUT_BUFFER = 'b', BROADWAY_OP_SET_SHOW_KEYBOARD = 'k'
"
j="\
    TBroadwayEventType* {.size: sizeof(cint).} = enum 
      BROADWAY_EVENT_BUTTON_RELEASE = 'B',
      BROADWAY_EVENT_KEY_RELEASE = 'K',
      BROADWAY_EVENT_DELETE_NOTIFY = 'W', 
      BROADWAY_EVENT_BUTTON_PRESS = 'b', 
      BROADWAY_EVENT_SCREEN_SIZE_CHANGED = 'd',
      BROADWAY_EVENT_ENTER = 'e',
      BROADWAY_EVENT_FOCUS = 'f',
      BROADWAY_EVENT_GRAB_NOTIFY = 'g', 
      BROADWAY_EVENT_KEY_PRESS = 'k', 
      BROADWAY_EVENT_LEAVE = 'l', 
      BROADWAY_EVENT_POINTER_MOVE = 'm',
      BROADWAY_EVENT_SCROLL = 's',
      BROADWAY_EVENT_TOUCH = 't', 
      BROADWAY_EVENT_UNGRAB_NOTIFY = 'u', 
      BROADWAY_EVENT_CONFIGURE_NOTIFY = 'w', 
    TBroadwayOpType* {.size: sizeof(cint).} = enum 
      BROADWAY_OP_DISCONNECTED = 'D', 
      BROADWAY_OP_HIDE_SURFACE = 'H',
      BROADWAY_OP_AUTH_OK = 'L',
      BROADWAY_OP_LOWER_SURFACE = 'R',
      BROADWAY_OP_SHOW_SURFACE = 'S', 
      BROADWAY_OP_PUT_BUFFER = 'b',
      BROADWAY_OP_DESTROY_SURFACE = 'd', 
      BROADWAY_OP_GRAB_POINTER = 'g',
      BROADWAY_OP_PUT_RGB = 'i',
      BROADWAY_OP_SET_SHOW_KEYBOARD = 'k',
      BROADWAY_OP_REQUEST_AUTH = 'l', 
      BROADWAY_OP_MOVE_RESIZE = 'm',
      BROADWAY_OP_SET_TRANSIENT_FOR = 'p', 
      BROADWAY_OP_RAISE_SURFACE = 'r', 
      BROADWAY_OP_NEW_SURFACE = 's',
      BROADWAY_OP_UNGRAB_POINTER = 'u', 
"

perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
    TBroadwayRequestType* {.size: sizeof(cint).} = enum 
      BROADWAY_REQUEST_NEW_WINDOW, BROADWAY_REQUEST_FLUSH, 
      BROADWAY_REQUEST_SYNC, BROADWAY_REQUEST_QUERY_MOUSE, 
      BROADWAY_REQUEST_DESTROY_WINDOW, BROADWAY_REQUEST_SHOW_WINDOW, 
      BROADWAY_REQUEST_HIDE_WINDOW, BROADWAY_REQUEST_SET_TRANSIENT_FOR, 
      BROADWAY_REQUEST_UPDATE, BROADWAY_REQUEST_MOVE_RESIZE, 
      BROADWAY_REQUEST_GRAB_POINTER, BROADWAY_REQUEST_UNGRAB_POINTER, 
      BROADWAY_REQUEST_FOCUS_WINDOW, BROADWAY_REQUEST_SET_SHOW_KEYBOARD
"
j="\
    TBroadwayRequestType* {.size: sizeof(cint).} = enum 
      BROADWAY_REQUEST_NEW_WINDOW_ENUM, BROADWAY_REQUEST_FLUSH_ENUM, 
      BROADWAY_REQUEST_SYNC_ENUM, BROADWAY_REQUEST_QUERY_MOUSE_ENUM, 
      BROADWAY_REQUEST_DESTROY_WINDOW_ENUM, BROADWAY_REQUEST_SHOW_WINDOW_ENUM, 
      BROADWAY_REQUEST_HIDE_WINDOW_ENUM, BROADWAY_REQUEST_SET_TRANSIENT_FOR_ENUM, 
      BROADWAY_REQUEST_UPDATE_ENUM, BROADWAY_REQUEST_MOVE_RESIZE_ENUM, 
      BROADWAY_REQUEST_GRAB_POINTER_ENUM, BROADWAY_REQUEST_UNGRAB_POINTER_ENUM, 
      BROADWAY_REQUEST_FOCUS_WINDOW_ENUM, BROADWAY_REQUEST_SET_SHOW_KEYBOARD_ENUM
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
    TBroadwayReplyType* {.size: sizeof(cint).} = enum 
      BROADWAY_REPLY_EVENT, BROADWAY_REPLY_SYNC, BROADWAY_REPLY_QUERY_MOUSE, 
      BROADWAY_REPLY_NEW_WINDOW, BROADWAY_REPLY_GRAB_POINTER, 
      BROADWAY_REPLY_UNGRAB_POINTER
"
j="\
    TBroadwayReplyType* {.size: sizeof(cint).} = enum 
      BROADWAY_REPLY_EVENT_ENUM, BROADWAY_REPLY_SYNC_ENUM, BROADWAY_REPLY_QUERY_MOUSE_ENUM, 
      BROADWAY_REPLY_NEW_WINDOW_ENUM, BROADWAY_REPLY_GRAB_POINTER_ENUM, 
      BROADWAY_REPLY_UNGRAB_POINTER_ENUM
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

sed  -i "s/OSX_UNSUPPORTED = 0, OSX_MIN = 4, OSX_TIGER = 4,/OSX_UNSUPPORTED = 0, OSX_TIGER = 4,/" final.nim
sed  -i "s/OSX_MOUNTAIN_LION = 8, OSX_CURRENT = 8, OSX_NEW = 99/OSX_MOUNTAIN_LION = 8, OSX_NEW = 99/" final.nim

i="\
type 
  TDragProtocol* {.size: sizeof(cint).} = enum 
"
j="\
type
  PDragProtocol* = ptr TDragProtocol
  TDragProtocol* {.size: sizeof(cint).} = enum 
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
type 
  TEventMask* {.size: sizeof(cint).} = enum 
"
j="\
type
  PEventMask* = ptr TEventMask
  TEventMask* {.size: sizeof(cint).} = enum 
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

# We may do that
#sed  -i "s/ Atom/ XAtom/" final.nim
#sed  -i "s/TGdkAtom/TAtom/" final.nim
#sed  -i "s/PGdkAtom/PAtom/" final.nim

sed  -i "s/ TGdkWindowEdge/ TWindowEdge/" final.nim
sed  -i "s/ TGdkWindowHints/ TWindowHints/" final.nim

for i in $opt ; do
  sed -i "s/  T${i}\* = object/  T${i}\* = object of TGObject/g" final.nim
done

for i in $fix2objof ; do
  sed -i "s/  T${i}\* = object/  T${i}\* = object of TGObject/g" final.nim
done

sed -i "s/\(TGdkDisplayManagerClass\* = object\)/\1 of TGObjectClass/g" final.nim

ruby ../fix_object_of.rb final.nim

ruby ../fix_proc_gtk.rb final.nim gdk_x11_
ruby ../fix_proc_gtk.rb final.nim gdk_

sed -i "s/\* = object $/\*{\.final, pure\.} = object /g" final.nim
sed -i "s/\(^\s*proc \)ref\(\*(\w\)/\1re\2/g" final.nim

sed -i "s/\(^\s*proc \)gdk_/\1/g" final.nim

i="\
proc drag_motion*(context: PDragContext; dest_window: PGdkWindow; 
                      protocol: TDragProtocol; x_root: gint; y_root: gint; 
                      suggested_action: TDragAction; 
                      possible_actions: TDragAction; time: guint32): gboolean {.
    cdecl, importc: \"gdk_drag_motion\", dynlib: lib.}
"
j="\
proc gdk_drag_motion*(context: PDragContext; dest_window: PGdkWindow; 
                      protocol: TDragProtocol; x_root: gint; y_root: gint; 
                      suggested_action: TDragAction; 
                      possible_actions: TDragAction; time: guint32): gboolean {.
    cdecl, importc: \"gdk_drag_motion\", dynlib: lib.}
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
proc drag_status*(context: PDragContext; action: TDragAction; 
                      time: guint32) {.cdecl, importc: \"gdk_drag_status\", 
    dynlib: lib.}
"
j="\
proc gdk_drag_status*(context: PDragContext; action: TDragAction; 
                      time: guint32) {.cdecl, importc: \"gdk_drag_status\", 
    dynlib: lib.}
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
proc property_delete*(window: PGdkWindow; property: TGdkAtom) {.cdecl, 
    importc: \"gdk_property_delete\", dynlib: lib.}
"
j="\
proc gdk_property_delete*(window: PGdkWindow; property: TGdkAtom) {.cdecl, 
    importc: \"gdk_property_delete\", dynlib: lib.}
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
proc destroy*(window: PGdkWindow) {.cdecl, 
    importc: \"gdk_window_destroy\", dynlib: lib.}
"
j="\
proc window_destroy*(window: PGdkWindow) {.cdecl, 
    importc: \"gdk_window_destroy\", dynlib: lib.}
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
proc scroll*(window: PGdkWindow; dx: gint; dy: gint) {.cdecl, 
    importc: \"gdk_window_scroll\", dynlib: lib.}
"
j="\
proc window_scroll*(window: PGdkWindow; dx: gint; dy: gint) {.cdecl, 
    importc: \"gdk_window_scroll\", dynlib: lib.}
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
proc raise*(window: PGdkWindow) {.cdecl, 
    importc: \"gdk_window_raise\", dynlib: lib.}
"
j="\
proc window_raise*(window: PGdkWindow) {.cdecl, 
    importc: \"gdk_window_raise\", dynlib: lib.}
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

i="\
    BroadwayInputMsg* = object  {.union.}
      base*: TBroadwayInputBaseMsg
"
j="\
    PBroadwayInputMsg* = ptr TBroadwayInputMsg
    TBroadwayInputMsg* = object  {.union.}
      base*: TBroadwayInputBaseMsg
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim
sed -i "s/msg\*: BroadwayInputMsg/msg\*: TBroadwayInputMsg/g" final.nim
sed -i "s/ GdkBroadwayDisplay/ TGdkBroadwayDisplay/g" final.nim

i="\
    type 
      TGdkBroadwayDisplay* = TGdkDisplay
"
j="\
    type
      PGdkBroadwayDisplay* = ptr TGdkBroadwayDisplay
      TGdkBroadwayDisplay* = TGdkDisplay
"
perl -0777 -p -i -e "s/\Q$i\E/$j/s" final.nim

sed -i "s/ GdkBroadwayWindow/ TGdkBroadwayWindow/g" final.nim
sed -i "s/ GdkBroadwayVisual/ TGdkBroadwayVisual/g" final.nim
sed -i "s/ GdkBroadwayCursor/ TGdkBroadwayCursor/g" final.nim
sed -i "s/ GdkBroadwayServer/ TGdkBroadwayServer/g" final.nim

# do not export priv and reserved
sed -i "s/\( priv[0-9]\?[0-9]\?[0-9]\?\)\*: /\1: /g" final.nim
sed -i "s/\(reserved[0-9]\?[0-9]\?[0-9]\?\)\*: /\1: /g" final.nim

sed -i "s/ X11AppLaunchContext/ TX11AppLaunchContext/g" final.nim
sed -i "s/ X11Cursor/ TX11Cursor/g" final.nim
sed -i "s/ X11DisplayManager/ TX11DisplayManager/g" final.nim
sed -i "s/ X11DragContext/ TX11DragContext/g" final.nim
sed -i "s/ X11Keymap/ TX11Keymap/g" final.nim
sed -i "s/ X11Screen/ TX11Screen/g" final.nim
sed -i "s/ X11Visual/ TX11Visual/g" final.nim
sed -i "s/ X11Window/ TX11Window/g" final.nim
sed -i "s/ X11Display/ TX11Display/g" final.nim
sed -i "s/ Win32Cursor/ TWin32Cursor/g" final.nim
sed -i "s/ Win32Display/ TWin32Display/g" final.nim
sed -i "s/ Win32DisplayManager/ TWin32DisplayManager/g" final.nim
sed -i "s/ Win32DragContext/ TWin32DragContext/g" final.nim
sed -i "s/ Win32Keymap/ TWin32Keymap/g" final.nim
sed -i "s/ Win32Screen/ TWin32Screen/g" final.nim
sed -i "s/ Win32Window/ TWin32Window/g" final.nim
sed -i "s/ WaylandDevice/ TWaylandDevice/g" final.nim
sed -i "s/ WaylandDisplay/ TWaylandDisplay/g" final.nim
sed -i "s/ WaylandWindow/ TWaylandWindow/g" final.nim
sed -i "s/ QuartzCursor/ TQuartzCursor/g" final.nim
sed -i "s/ QuartzDisplay/ TQuartzDisplay/g" final.nim
sed -i "s/ QuartzDisplayManager/ TQuartzDisplayManager/g" final.nim
sed -i "s/ QuartzDragContext/ TQuartzDragContext/g" final.nim
sed -i "s/ QuartzKeymap/ TQuartzKeymap/g" final.nim
sed -i "s/ QuartzScreen/ TQuartzScreen/g" final.nim
sed -i "s/ QuartzVisual/ TQuartzVisual/g" final.nim
sed -i "s/ QuartzWindow/ TQuartzWindow/g" final.nim

#sed -i "s/proc get_setting\*(/wxyz get_setting\*(/g" final.nim
#sed -i "s/proc get_modifier_mask\*(/wxyz get_modifier_mask\*(/g" final.nim
perl -0777 -p -i -e "s/(\nproc set_)(\w\w*)(\*\(.*?})/\1\2\3\nproc \`\2=\`\3/sg" final.nim
perl -0777 -p -i -e "s/(\nproc get_)(\w\w*)(\*\(.*?})/\1\2\3\nproc \2\3/sg" final.nim
#sed -i "s/wxyz get_setting\*(/proc get_setting\*(/g" final.nim
#sed -i "s/wxyz get_modifier_mask\*(/proc get_modifier_mask\*(/g" final.nim

ruby ../fix_enum_prefix.rb final.nim

mv final.nim gdk3.nim

#nimrod c gdk3.nim

